/*
 * Decompiled with CFR 0.152.
 */
package academy.alex;

import academy.alex.Util;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public abstract class CustomMatcher
extends Util {
    public static Matcher<String> validType() {
        return new Type();
    }

    public static Matcher<String> validNumber() {
        return new Luhn();
    }

    public static Matcher<String> validExpiration() {
        return new Expiration();
    }

    public static Matcher<String> validCVV() {
        return new CVV();
    }

    public static class CVV
    extends TypeSafeDiagnosingMatcher<String> {
        public void describeTo(Description description) {
            description.appendText("Credit Card CVV ").appendText(" must be valid");
        }

        protected boolean matchesSafely(String cc_type_cvv, Description description) {
            String type = cc_type_cvv.split(":")[0];
            String cvv = cc_type_cvv.split(":")[1];
            if (type.equals("American Express")) {
                return cvv.matches("^(\\d{4})$");
            }
            return cvv.matches("^(\\d{3})$");
        }
    }

    public static class Expiration
    extends TypeSafeDiagnosingMatcher<String> {
        public void describeTo(Description description) {
            description.appendText("Credit Card expiration ").appendText(" must be valid");
        }

        protected boolean matchesSafely(String cc_exp, Description description) {
            int exp = Integer.parseInt(cc_exp.substring(3, 5) + cc_exp.substring(0, 2));
            description.appendValue((Object)cc_exp).appendText(" is already expired");
            return Util.today() <= exp;
        }
    }

    public static class Luhn
    extends TypeSafeDiagnosingMatcher<String> {
        public void describeTo(Description description) {
            description.appendText("Credit Card  number ").appendText(" must be valid");
        }

        protected boolean matchesSafely(String cc_number, Description description) {
            String number = new String(cc_number.replaceAll("\\s", "").replaceAll("-", ""));
            int sum = 0;
            boolean swap = false;
            for (int i = number.length() - 1; i >= 0; --i) {
                int digit = Integer.parseInt(number.substring(i, i + 1));
                if (swap && (digit *= 2) > 9) {
                    digit -= 9;
                }
                sum += digit;
                swap = !swap;
            }
            description.appendValue((Object)cc_number).appendText(" is not valid");
            return sum % 10 == 0;
        }
    }

    public static class Type
    extends TypeSafeDiagnosingMatcher<String> {
        public void describeTo(Description description) {
            description.appendText("Credit Card type ").appendText(" must be valid");
        }

        protected boolean matchesSafely(String cc_type_number, Description description) {
            String type = cc_type_number.split(":")[0];
            String number = cc_type_number.split(":")[1].replaceAll("\\s", "").replaceAll("-", "");
            if (number.startsWith("4") && (number.length() == 13 || number.length() == 16) && type.equals("VISA")) {
                return true;
            }
            if ((number.startsWith("51") || number.startsWith("52") || number.startsWith("53") || number.startsWith("54") || number.startsWith("55")) && number.length() == 16 && type.equals("MasterCard")) {
                return true;
            }
            if ((number.startsWith("6011") || number.startsWith("62") || number.startsWith("64") || number.startsWith("65")) && number.length() == 16 && type.equals("Discover")) {
                return true;
            }
            return (number.startsWith("34") || number.startsWith("37")) && number.length() == 15 && type.equals("American Express");
        }
    }
}

