/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.geohash.queries;

import ch.hsr.geohash.BoundingBox;
import ch.hsr.geohash.GeoHash;
import ch.hsr.geohash.WGS84Point;
import ch.hsr.geohash.queries.GeoHashBoundingBoxQuery;
import ch.hsr.geohash.queries.GeoHashQuery;
import ch.hsr.geohash.util.VincentyGeodesy;
import java.io.Serializable;
import java.util.List;

public class GeoHashCircleQuery
implements GeoHashQuery,
Serializable {
    private static final long serialVersionUID = 1263295371663796291L;
    private double radius;
    private GeoHashBoundingBoxQuery query;
    private WGS84Point center;

    public GeoHashCircleQuery(WGS84Point center, double radius) {
        this.radius = radius;
        this.center = center;
        WGS84Point northEast = VincentyGeodesy.moveInDirection(VincentyGeodesy.moveInDirection(center, 0.0, radius), 90.0, radius);
        WGS84Point southWest = VincentyGeodesy.moveInDirection(VincentyGeodesy.moveInDirection(center, 180.0, radius), 270.0, radius);
        BoundingBox bbox = new BoundingBox(northEast, southWest);
        this.query = new GeoHashBoundingBoxQuery(bbox);
    }

    @Override
    public boolean contains(GeoHash hash) {
        return this.query.contains(hash);
    }

    @Override
    public String getWktBox() {
        return this.query.getWktBox();
    }

    @Override
    public List<GeoHash> getSearchHashes() {
        return this.query.getSearchHashes();
    }

    public String toString() {
        return "Cicle Query [center=" + this.center + ", radius=" + this.getRadiusString() + "]";
    }

    private String getRadiusString() {
        if (this.radius > 1000.0) {
            return this.radius / 1000.0 + "km";
        }
        return this.radius + "m";
    }

    @Override
    public boolean contains(WGS84Point point) {
        return this.query.contains(point);
    }
}

