/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.socket.nio;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.socket.nio.Operation;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public abstract class NioServer
implements Closeable {
    private Selector selector;
    private ServerSocketChannel serverSocketChannel;

    public NioServer(int port) {
        this.init(new InetSocketAddress(port));
    }

    public NioServer init(InetSocketAddress address) {
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.configureBlocking(false);
            ServerSocket serverSocket = this.serverSocketChannel.socket();
            serverSocket.bind(address);
            this.selector = Selector.open();
            this.serverSocketChannel.register(this.selector, 16);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    public void listen() {
        try {
            this.doListen();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private void doListen() throws IOException {
        while (0 != this.selector.select()) {
            Iterator<SelectionKey> keyIter = this.selector.selectedKeys().iterator();
            while (keyIter.hasNext()) {
                this.handle(keyIter.next());
                keyIter.remove();
            }
        }
    }

    private void handle(SelectionKey key) {
        SocketChannel socketChannel;
        if (key.isAcceptable()) {
            SocketChannel socketChannel2;
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            try {
                socketChannel2 = server.accept();
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            this.registerChannel(this.selector, socketChannel2, Operation.READ);
        }
        if (key.isReadable()) {
            socketChannel = (SocketChannel)key.channel();
            this.read(socketChannel);
            this.registerChannel(this.selector, socketChannel, Operation.WRITE);
        }
        if (key.isWritable()) {
            socketChannel = (SocketChannel)key.channel();
            this.write(socketChannel);
            this.registerChannel(this.selector, socketChannel, Operation.READ);
        }
    }

    @Override
    public void close() {
        IoUtil.close(this.selector);
        IoUtil.close(this.serverSocketChannel);
    }

    protected abstract void read(SocketChannel var1);

    protected abstract void write(SocketChannel var1);

    private void registerChannel(Selector selector, SelectableChannel channel, Operation ops) {
        if (channel == null) {
            return;
        }
        try {
            channel.configureBlocking(false);
            channel.register(selector, ops.getValue());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

