/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text.csv;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.csv.CsvData;
import cn.hutool.core.text.csv.CsvParser;
import cn.hutool.core.text.csv.CsvReadConfig;
import cn.hutool.core.text.csv.CsvRow;
import cn.hutool.core.text.csv.CsvRowHandler;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CsvBaseReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;
    private final CsvReadConfig config;

    public CsvBaseReader() {
        this(null);
    }

    public CsvBaseReader(CsvReadConfig config) {
        this.config = ObjectUtil.defaultIfNull(config, CsvReadConfig.defaultConfig());
    }

    public void setFieldSeparator(char fieldSeparator) {
        this.config.setFieldSeparator(fieldSeparator);
    }

    public void setTextDelimiter(char textDelimiter) {
        this.config.setTextDelimiter(textDelimiter);
    }

    public void setContainsHeader(boolean containsHeader) {
        this.config.setContainsHeader(containsHeader);
    }

    public void setSkipEmptyRows(boolean skipEmptyRows) {
        this.config.setSkipEmptyRows(skipEmptyRows);
    }

    public void setErrorOnDifferentFieldCount(boolean errorOnDifferentFieldCount) {
        this.config.setErrorOnDifferentFieldCount(errorOnDifferentFieldCount);
    }

    public CsvData read(File file) throws IORuntimeException {
        return this.read(file, DEFAULT_CHARSET);
    }

    public CsvData read(File file, Charset charset) throws IORuntimeException {
        return this.read(Objects.requireNonNull(file.toPath(), "file must not be null"), charset);
    }

    public CsvData read(Path path) throws IORuntimeException {
        return this.read(path, DEFAULT_CHARSET);
    }

    public CsvData read(Path path, Charset charset) throws IORuntimeException {
        Assert.notNull(path, "path must not be null", new Object[0]);
        return this.read(FileUtil.getReader(path, charset));
    }

    public CsvData read(Reader reader) throws IORuntimeException {
        CsvParser csvParser = this.parse(reader);
        ArrayList<CsvRow> rows = new ArrayList<CsvRow>();
        this.read(csvParser, rows::add);
        List<String> header = this.config.containsHeader ? csvParser.getHeader() : null;
        return new CsvData(header, rows);
    }

    public List<Map<String, String>> readMapList(Reader reader) throws IORuntimeException {
        this.config.setContainsHeader(true);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        this.read(reader, (CsvRow row) -> result.add(row.getFieldMap()));
        return result;
    }

    public <T> List<T> read(Reader reader, Class<T> clazz) {
        this.config.setContainsHeader(true);
        ArrayList result = new ArrayList();
        this.read(reader, (CsvRow row) -> result.add(row.toBean(clazz)));
        return result;
    }

    public void read(Reader reader, CsvRowHandler rowHandler) throws IORuntimeException {
        this.read(this.parse(reader), rowHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(CsvParser csvParser, CsvRowHandler rowHandler) throws IORuntimeException {
        try {
            CsvRow csvRow;
            while ((csvRow = csvParser.nextRow()) != null) {
                rowHandler.handle(csvRow);
            }
        }
        finally {
            IoUtil.close(csvParser);
        }
    }

    private CsvParser parse(Reader reader) throws IORuntimeException {
        return new CsvParser(reader, this.config);
    }
}

