/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ftp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.FtpConfig;
import cn.hutool.extra.ftp.FtpException;
import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;

public abstract class AbstractFtp
implements Closeable {
    public static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;
    protected FtpConfig ftpConfig;

    protected AbstractFtp(FtpConfig config) {
        this.ftpConfig = config;
    }

    public abstract AbstractFtp reconnectIfTimeout();

    public abstract boolean cd(String var1);

    public boolean toParent() {
        return this.cd("..");
    }

    public abstract String pwd();

    public abstract boolean mkdir(String var1);

    public boolean exist(String path) {
        List<String> names;
        String fileName = FileUtil.getName(path);
        String dir = StrUtil.removeSuffix(path, fileName);
        try {
            names = this.ls(dir);
        }
        catch (FtpException ignore) {
            return false;
        }
        return AbstractFtp.containsIgnoreCase(names, fileName);
    }

    public abstract List<String> ls(String var1);

    public abstract boolean delFile(String var1);

    public abstract boolean delDir(String var1);

    public void mkDirs(String dir) {
        String[] dirs = StrUtil.trim(dir).split("[\\\\/]+");
        String now = this.pwd();
        if (dirs.length > 0 && StrUtil.isEmpty(dirs[0])) {
            this.cd("/");
        }
        for (String s : dirs) {
            if (!StrUtil.isNotEmpty(s) || this.cd(s)) continue;
            this.mkdir(s);
            this.cd(s);
        }
        this.cd(now);
    }

    public abstract boolean upload(String var1, File var2);

    public abstract void download(String var1, File var2);

    public abstract void recursiveDownloadFolder(String var1, File var2);

    private static boolean containsIgnoreCase(List<String> names, String nameToFind) {
        if (CollUtil.isEmpty(names)) {
            return false;
        }
        if (StrUtil.isEmpty(nameToFind)) {
            return false;
        }
        for (String name : names) {
            if (!nameToFind.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

