/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2002 - 2007 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package flex.messaging.config;

/**
 * Settings for <code>LoginCommand</code> class.
 *
 * @author esolovey
 * @exclude
 */
public class LoginCommandSettings
{
    public static final String SERVER_MATCH_OVERRIDE = "all";

    private String className;
    private String server;
    private boolean perClientAuthentication;

    /**
     * Create a new <code>LoginCommandSettings</code> instance with default settings.
     */
    public LoginCommandSettings()
    {
        perClientAuthentication = false;
    }

    /**
     * Returns the class name associated with the settings.
     *
     * @return The class name.
     */
    public String getClassName()
    {
        return className;
    }

    /**
     * Sets the class name associated with the settings.
     *
     * @param className The class name.
     */
    public void setClassName(String className)
    {
        this.className = className;
    }

    /**
     * Returns the server name associated with the settings.
     *
     * @return The server name.
     */
    public String getServer()
    {
        return server;
    }

    /**
     * Sets the server name associated with the settings.
     *
     * @param server The server name.
     */
    public void setServer(String server)
    {
        this.server = server;
    }

    /**
     * Returns whether per client authentication is enabled or not.
     *
     * @return <code>true</code> if per client authentication is enabled;
     * otherwise <code>false</code>.
     */
    public boolean isPerClientAuthentication()
    {
        return perClientAuthentication;
    }

    /**
     * Sets whether per client authentication is enabled or not.
     *
     * @param perClientAuthentication <code>true</code> if per client authentication
     * is enabled; otherwise <code>false</code>.
     */
    public void setPerClientAuthentication(boolean perClientAuthentication)
    {
        this.perClientAuthentication = perClientAuthentication;
    }
}
