/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2002 - 2007 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package flex.messaging.config;

import java.util.List;
import java.util.Map;

/**
 * Base interface for Flex Data Services configuration.
 *
 * Implementations may have different levels of detail
 * based on how much of the configuration is supported.
 *
 * @author pfarland
 * @exclude
 */
public interface ServicesConfiguration
{
    /*
     * CHANNEL CONFIGURATION
     */

    void addChannelSettings(String id, ChannelSettings settings);

    ChannelSettings getChannelSettings(String ref);

    Map getAllChannelSettings();

    /*
     * DEFAULT CHANNELS CONFIGURATION
     */
    void addDefaultChannel(String id);

    List getDefaultChannels();

    /*
     * SERVICE CONFIGURATION
     */

    void addServiceSettings(ServiceSettings settings);

    ServiceSettings getServiceSettings(String id);

    List getAllServiceSettings();

    /*
     * LOGGING CONFIGURATION
     */
    void setLoggingSettings(LoggingSettings settings);

    LoggingSettings getLoggingSettings();

    /* CLUSTER CONFIGURATION */
    ClusterSettings getClusterSettings(String clusterId);

    ClusterSettings getDefaultCluster();
}
