/*
 * Decompiled with CFR 0.152.
 */
package flex.management.runtime.messaging;

import flex.management.BaseControl;
import flex.management.runtime.messaging.DestinationControl;
import flex.management.runtime.messaging.MessageDestinationControlMBean;
import flex.messaging.Destination;
import java.util.Date;
import javax.management.ObjectName;

public class MessageDestinationControl
extends DestinationControl
implements MessageDestinationControlMBean {
    private static final String TYPE = "MessageDestination";
    private ObjectName messageCache;
    private ObjectName throttleManager;
    private ObjectName subscriptionManager;
    private int serviceMessageCount = 0;
    private Date lastServiceMessageTimestamp;
    private long serviceMessageStart;
    private int serviceCommandCount = 0;
    private Date lastServiceCommandTimestamp;
    private long serviceCommandStart = this.serviceMessageStart = System.currentTimeMillis();
    private int serviceMessageFromAdapterCount = 0;
    private Date lastServiceMessageFromAdapterTimestamp;
    private long serviceMessageFromAdapterStart = this.serviceMessageStart;

    public MessageDestinationControl(Destination destination, BaseControl parent) {
        super(destination, parent);
    }

    protected void onRegistrationComplete() {
        String name = this.getObjectName().getCanonicalName();
        String[] pollablePerInterval = new String[]{"ServiceCommandCount", "ServiceMessageCount", "ServiceMessageFromAdapterCount"};
        String[] pollableGeneral = new String[]{"ServiceCommandFrequency", "ServiceMessageFrequency", "ServiceMessageFromAdapterFrequency", "LastServiceCommandTimestamp", "LastServiceMessageTimestamp", "LastServiceMessageFromAdapterTimestamp"};
        this.getRegistrar().registerObjects(new int[]{151, 50}, name, pollablePerInterval);
        this.getRegistrar().registerObjects(151, name, pollableGeneral);
    }

    public String getType() {
        return TYPE;
    }

    public ObjectName getMessageCache() {
        return this.messageCache;
    }

    public void setMessageCache(ObjectName value) {
        this.messageCache = value;
    }

    public ObjectName getThrottleManager() {
        return this.throttleManager;
    }

    public void setThrottleManager(ObjectName value) {
        this.throttleManager = value;
    }

    public ObjectName getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public void setSubscriptionManager(ObjectName value) {
        this.subscriptionManager = value;
    }

    public Integer getServiceMessageCount() {
        return new Integer(this.serviceMessageCount);
    }

    public void resetServiceMessageCount() {
        this.serviceMessageStart = System.currentTimeMillis();
        this.serviceMessageCount = 0;
        this.lastServiceMessageTimestamp = null;
    }

    public void incrementServiceMessageCount() {
        ++this.serviceMessageCount;
        this.lastServiceMessageTimestamp = new Date();
    }

    public Date getLastServiceMessageTimestamp() {
        return this.lastServiceMessageTimestamp;
    }

    public Double getServiceMessageFrequency() {
        if (this.serviceMessageCount > 0) {
            double runtime = this.differenceInMinutes(this.serviceMessageStart, System.currentTimeMillis());
            return new Double((double)this.serviceMessageCount / runtime);
        }
        return new Double(0.0);
    }

    public Integer getServiceCommandCount() {
        return new Integer(this.serviceCommandCount);
    }

    public void resetServiceCommandCount() {
        this.serviceCommandStart = System.currentTimeMillis();
        this.serviceCommandCount = 0;
        this.lastServiceCommandTimestamp = null;
    }

    public void incrementServiceCommandCount() {
        ++this.serviceCommandCount;
        this.lastServiceCommandTimestamp = new Date();
    }

    public Date getLastServiceCommandTimestamp() {
        return this.lastServiceCommandTimestamp;
    }

    public Double getServiceCommandFrequency() {
        if (this.serviceCommandCount > 0) {
            double runtime = this.differenceInMinutes(this.serviceCommandStart, System.currentTimeMillis());
            return new Double((double)this.serviceCommandCount / runtime);
        }
        return new Double(0.0);
    }

    public Integer getServiceMessageFromAdapterCount() {
        return new Integer(this.serviceMessageFromAdapterCount);
    }

    public void resetServiceMessageFromAdapterCount() {
        this.serviceMessageFromAdapterStart = System.currentTimeMillis();
        this.serviceMessageFromAdapterCount = 0;
        this.lastServiceMessageFromAdapterTimestamp = null;
    }

    public void incrementServiceMessageFromAdapterCount() {
        ++this.serviceMessageFromAdapterCount;
        this.lastServiceMessageFromAdapterTimestamp = new Date();
    }

    public Date getLastServiceMessageFromAdapterTimestamp() {
        return this.lastServiceMessageFromAdapterTimestamp;
    }

    public Double getServiceMessageFromAdapterFrequency() {
        if (this.serviceMessageFromAdapterCount > 0) {
            double runtime = this.differenceInMinutes(this.serviceMessageFromAdapterStart, System.currentTimeMillis());
            return new Double((double)this.serviceMessageFromAdapterCount / runtime);
        }
        return new Double(0.0);
    }
}

