/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.io.AbstractProxy;
import flex.messaging.io.ClassAliasRegistry;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.UnknownTypeException;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.AbstractAmfInput;
import flex.messaging.io.amf.ActionMessageInput;
import flex.messaging.io.amf.Amf3Input;
import flex.messaging.io.amf.AmfTypes;
import flex.messaging.util.ClassUtil;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Amf0Input
extends AbstractAmfInput
implements AmfTypes {
    protected ActionMessageInput avmPlusInput;
    protected List objectsTable = new ArrayList(64);

    public Amf0Input(SerializationContext context) {
        super(context);
    }

    public void reset() {
        super.reset();
        this.objectsTable.clear();
        if (this.avmPlusInput != null) {
            this.avmPlusInput.reset();
        }
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        byte type = this.in.readByte();
        Object value = this.readObjectValue(type);
        return value;
    }

    protected Object readObjectValue(int type) throws ClassNotFoundException, IOException {
        Object value = null;
        switch (type) {
            case 0: {
                double d = this.readDouble();
                if (this.isDebug) {
                    this.trace.write(d);
                }
                value = new Double(d);
                break;
            }
            case 1: {
                value = this.readBoolean();
                if (!this.isDebug) break;
                this.trace.write(value);
                break;
            }
            case 2: {
                value = this.readString();
                break;
            }
            case 17: {
                if (this.avmPlusInput == null) {
                    this.avmPlusInput = new Amf3Input(this.context);
                    this.avmPlusInput.setDebugTrace(this.trace);
                    this.avmPlusInput.setInputStream(this.in);
                }
                value = this.avmPlusInput.readObject();
                break;
            }
            case 10: {
                value = this.readArrayValue();
                break;
            }
            case 16: {
                String typeName = this.in.readUTF();
                value = this.readObjectValue(typeName);
                break;
            }
            case 12: {
                value = this.readLongUTF();
                if (!this.isDebug) break;
                this.trace.writeString((String)value);
                break;
            }
            case 3: {
                value = this.readObjectValue(null);
                break;
            }
            case 15: {
                value = this.readXml();
                break;
            }
            case 5: {
                if (!this.isDebug) break;
                this.trace.writeNull();
                break;
            }
            case 11: {
                value = this.readDate();
                break;
            }
            case 8: {
                value = this.readECMAArrayValue();
                break;
            }
            case 7: {
                int refNum = this.in.readUnsignedShort();
                if (this.isDebug) {
                    this.trace.writeRef(refNum);
                }
                value = this.objectsTable.get(refNum);
                break;
            }
            case 6: {
                if (!this.isDebug) break;
                this.trace.writeUndefined();
                break;
            }
            case 13: {
                if (this.isDebug) {
                    this.trace.write("UNSUPPORTED");
                }
                UnknownTypeException ex = new UnknownTypeException();
                ex.setMessage(10302);
                throw ex;
            }
            case 9: {
                if (this.isDebug) {
                    this.trace.write("UNEXPECTED OBJECT END");
                }
                UnknownTypeException ex1 = new UnknownTypeException();
                ex1.setMessage(10303);
                throw ex1;
            }
            case 14: {
                if (this.isDebug) {
                    this.trace.write("UNEXPECTED RECORDSET");
                }
                UnknownTypeException ex2 = new UnknownTypeException();
                ex2.setMessage(10304);
                throw ex2;
            }
            default: {
                if (this.isDebug) {
                    this.trace.write("UNKNOWN TYPE");
                }
                UnknownTypeException ex3 = new UnknownTypeException();
                ex3.setMessage(10301, new Object[]{new Integer(type)});
                throw ex3;
            }
        }
        return value;
    }

    protected Date readDate() throws IOException {
        long time = (long)this.in.readDouble();
        this.in.readShort();
        Date d = new Date(time);
        if (this.isDebug) {
            this.trace.write(d.toString());
        }
        return d;
    }

    protected Map readECMAArrayValue() throws ClassNotFoundException, IOException {
        int size = this.in.readInt();
        HashMap<String, Object> h = size == 0 ? new HashMap<String, Object>() : new HashMap(size);
        this.rememberObject(h);
        if (this.isDebug) {
            this.trace.startECMAArray(this.objectsTable.size() - 1);
        }
        String name = this.in.readUTF();
        byte type = this.in.readByte();
        while (type != 9) {
            if (type != 9) {
                if (this.isDebug) {
                    this.trace.namedElement(name);
                }
                Object value = this.readObjectValue(type);
                if (!name.equals("length")) {
                    h.put(name, value);
                }
            }
            name = this.in.readUTF();
            type = this.in.readByte();
        }
        if (this.isDebug) {
            this.trace.endAMFArray();
        }
        return h;
    }

    protected String readString() throws IOException {
        String s = this.readUTF();
        if (this.isDebug) {
            this.trace.writeString(s);
        }
        return s;
    }

    protected Object readArrayValue() throws ClassNotFoundException, IOException {
        int size = this.in.readInt();
        ArrayList<Object> l = new ArrayList<Object>(size);
        this.rememberObject(l);
        if (this.isDebug) {
            this.trace.startAMFArray(this.objectsTable.size() - 1);
        }
        for (int i = 0; i < size; ++i) {
            byte type = this.in.readByte();
            if (this.isDebug) {
                this.trace.arrayElement(i);
            }
            l.add(this.readObjectValue(type));
        }
        if (this.isDebug) {
            this.trace.endAMFArray();
        }
        if (this.context.legacyCollection) {
            return l;
        }
        return l.toArray();
    }

    protected Object readObjectValue(String className) throws ClassNotFoundException, IOException {
        Object newObj;
        Object object;
        PropertyProxy proxy = null;
        String aliasedClass = ClassAliasRegistry.getRegistry().getClassName(className);
        if (aliasedClass != null) {
            className = aliasedClass;
        }
        if (className == null || className.length() == 0) {
            object = new ASObject();
        } else if (className.startsWith(">")) {
            object = new ASObject();
            ((ASObject)object).setType(className);
        } else if (this.context.instantiateTypes || className.startsWith("flex.")) {
            Class desiredClass = AbstractProxy.getClassFromClassName(className, this.context.createASObjectForMissingType);
            proxy = PropertyProxyRegistry.getRegistry().getProxyAndRegister(desiredClass);
            object = proxy == null ? ClassUtil.createDefaultInstance(desiredClass, null) : proxy.createInstance(className);
        } else {
            object = new ASObject();
            ((ASObject)object).setType(className);
        }
        if (proxy == null) {
            proxy = PropertyProxyRegistry.getProxyAndRegister(object);
        }
        int objectId = this.rememberObject(object);
        if (this.isDebug) {
            this.trace.startAMFObject(className, this.objectsTable.size() - 1);
        }
        String propertyName = this.in.readUTF();
        byte type = this.in.readByte();
        while (type != 9) {
            if (this.isDebug) {
                this.trace.namedElement(propertyName);
            }
            Object value = this.readObjectValue(type);
            proxy.setValue(object, propertyName, value);
            propertyName = this.in.readUTF();
            type = this.in.readByte();
        }
        if (this.isDebug) {
            this.trace.endAMFObject();
        }
        if ((newObj = proxy.instanceComplete(object)) != object) {
            this.objectsTable.set(objectId, newObj);
            object = newObj;
        }
        return object;
    }

    protected String readLongUTF() throws IOException {
        int utflen = this.in.readInt();
        char[] charr = this.getTempCharArray(utflen);
        byte[] bytearr = this.getTempByteArray(utflen);
        int count = 0;
        int chCount = 0;
        this.in.readFully(bytearr, 0, utflen);
        while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    charr[chCount] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    charr[chCount] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    charr[chCount] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
            ++chCount;
        }
        return new String(charr, 0, chCount);
    }

    protected Object readXml() throws IOException {
        String xml = this.readLongUTF();
        if (this.isDebug) {
            this.trace.write(xml);
        }
        return this.stringToDocument(xml);
    }

    protected int rememberObject(Object obj) {
        int id = this.objectsTable.size();
        this.objectsTable.add(obj);
        return id;
    }
}

