/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.directory.model.Attribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateComputerRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String directoryId;
    private String computerName;
    private String password;
    private String organizationalUnitDistinguishedName;
    private ListWithAutoConstructFlag<Attribute> computerAttributes;

    public String getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public CreateComputerRequest withDirectoryId(String directoryId) {
        this.directoryId = directoryId;
        return this;
    }

    public String getComputerName() {
        return this.computerName;
    }

    public void setComputerName(String computerName) {
        this.computerName = computerName;
    }

    public CreateComputerRequest withComputerName(String computerName) {
        this.computerName = computerName;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CreateComputerRequest withPassword(String password) {
        this.password = password;
        return this;
    }

    public String getOrganizationalUnitDistinguishedName() {
        return this.organizationalUnitDistinguishedName;
    }

    public void setOrganizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
        this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
    }

    public CreateComputerRequest withOrganizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
        this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
        return this;
    }

    public List<Attribute> getComputerAttributes() {
        if (this.computerAttributes == null) {
            this.computerAttributes = new ListWithAutoConstructFlag();
            this.computerAttributes.setAutoConstruct(true);
        }
        return this.computerAttributes;
    }

    public void setComputerAttributes(Collection<Attribute> computerAttributes) {
        if (computerAttributes == null) {
            this.computerAttributes = null;
            return;
        }
        ListWithAutoConstructFlag computerAttributesCopy = new ListWithAutoConstructFlag(computerAttributes.size());
        computerAttributesCopy.addAll(computerAttributes);
        this.computerAttributes = computerAttributesCopy;
    }

    public CreateComputerRequest withComputerAttributes(Attribute ... computerAttributes) {
        if (this.getComputerAttributes() == null) {
            this.setComputerAttributes(new ArrayList<Attribute>(computerAttributes.length));
        }
        for (Attribute value : computerAttributes) {
            this.getComputerAttributes().add(value);
        }
        return this;
    }

    public CreateComputerRequest withComputerAttributes(Collection<Attribute> computerAttributes) {
        if (computerAttributes == null) {
            this.computerAttributes = null;
        } else {
            ListWithAutoConstructFlag computerAttributesCopy = new ListWithAutoConstructFlag(computerAttributes.size());
            computerAttributesCopy.addAll(computerAttributes);
            this.computerAttributes = computerAttributesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryId() != null) {
            sb.append("DirectoryId: " + this.getDirectoryId() + ",");
        }
        if (this.getComputerName() != null) {
            sb.append("ComputerName: " + this.getComputerName() + ",");
        }
        if (this.getPassword() != null) {
            sb.append("Password: " + this.getPassword() + ",");
        }
        if (this.getOrganizationalUnitDistinguishedName() != null) {
            sb.append("OrganizationalUnitDistinguishedName: " + this.getOrganizationalUnitDistinguishedName() + ",");
        }
        if (this.getComputerAttributes() != null) {
            sb.append("ComputerAttributes: " + this.getComputerAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryId() == null ? 0 : this.getDirectoryId().hashCode());
        hashCode = 31 * hashCode + (this.getComputerName() == null ? 0 : this.getComputerName().hashCode());
        hashCode = 31 * hashCode + (this.getPassword() == null ? 0 : this.getPassword().hashCode());
        hashCode = 31 * hashCode + (this.getOrganizationalUnitDistinguishedName() == null ? 0 : this.getOrganizationalUnitDistinguishedName().hashCode());
        hashCode = 31 * hashCode + (this.getComputerAttributes() == null ? 0 : this.getComputerAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputerRequest)) {
            return false;
        }
        CreateComputerRequest other = (CreateComputerRequest)obj;
        if (other.getDirectoryId() == null ^ this.getDirectoryId() == null) {
            return false;
        }
        if (other.getDirectoryId() != null && !other.getDirectoryId().equals(this.getDirectoryId())) {
            return false;
        }
        if (other.getComputerName() == null ^ this.getComputerName() == null) {
            return false;
        }
        if (other.getComputerName() != null && !other.getComputerName().equals(this.getComputerName())) {
            return false;
        }
        if (other.getPassword() == null ^ this.getPassword() == null) {
            return false;
        }
        if (other.getPassword() != null && !other.getPassword().equals(this.getPassword())) {
            return false;
        }
        if (other.getOrganizationalUnitDistinguishedName() == null ^ this.getOrganizationalUnitDistinguishedName() == null) {
            return false;
        }
        if (other.getOrganizationalUnitDistinguishedName() != null && !other.getOrganizationalUnitDistinguishedName().equals(this.getOrganizationalUnitDistinguishedName())) {
            return false;
        }
        if (other.getComputerAttributes() == null ^ this.getComputerAttributes() == null) {
            return false;
        }
        return other.getComputerAttributes() == null || other.getComputerAttributes().equals(this.getComputerAttributes());
    }

    public CreateComputerRequest clone() {
        return (CreateComputerRequest)super.clone();
    }
}

