/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.junit;

import com.amazonaws.services.simpleworkflow.flow.junit.WorkflowTestBase;
import com.amazonaws.services.simpleworkflow.flow.test.TestDecisionContext;
import com.amazonaws.services.simpleworkflow.flow.test.TestLambdaFunctionClient;
import com.amazonaws.services.simpleworkflow.flow.test.TestPOJOActivityImplementationGenericActivityClient;
import com.amazonaws.services.simpleworkflow.flow.test.TestPOJOActivityImplementationWorker;
import com.amazonaws.services.simpleworkflow.flow.test.TestPOJOWorkflowImplementationGenericWorkflowClient;
import com.amazonaws.services.simpleworkflow.flow.test.TestWorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.test.TestWorkflowContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class WorkflowTest
extends WorkflowTestBase {
    private TestPOJOActivityImplementationGenericActivityClient activityClient;
    private TestPOJOWorkflowImplementationGenericWorkflowClient workflowClient;
    private Map<String, TestPOJOActivityImplementationWorker> workers = new HashMap<String, TestPOJOActivityImplementationWorker>();

    public WorkflowTest() {
        super(new TestDecisionContext(new TestPOJOActivityImplementationGenericActivityClient(), new TestPOJOWorkflowImplementationGenericWorkflowClient(), new TestWorkflowClock(), new TestWorkflowContext(), new TestLambdaFunctionClient()));
        this.activityClient = (TestPOJOActivityImplementationGenericActivityClient)this.decisionContext.getActivityClient();
        this.workflowClient = (TestPOJOWorkflowImplementationGenericWorkflowClient)this.decisionContext.getWorkflowClient();
    }

    public void addActivitiesImplementation(Object activitiesImplementation) {
        this.addActivitiesImplementation(this.defaultActivitiesTaskListToPoll, activitiesImplementation);
    }

    public void addActivitiesImplementation(String taskList, Object activitiesImplementation) {
        try {
            TestPOJOActivityImplementationWorker worker = this.getActivityWorker(taskList);
            worker.addActivitiesImplementation(activitiesImplementation);
            this.activityClient.addWorker(worker);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid activities implementation: " + activitiesImplementation, e);
        }
    }

    private TestPOJOActivityImplementationWorker getActivityWorker(String taskList) {
        TestPOJOActivityImplementationWorker result = this.workers.get(taskList);
        if (result == null) {
            result = new TestPOJOActivityImplementationWorker(taskList);
            this.workers.put(taskList, result);
        }
        return result;
    }

    public void addWorkflowImplementationType(Class<?> workflowImplementationType) {
        try {
            this.workflowClient.addWorkflowImplementationType(workflowImplementationType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid workflow type: " + workflowImplementationType, e);
        }
    }

    public void setActivitiesImplementations(Iterable<Object> activitiesImplementationObjects) {
        this.workers.clear();
        this.addActivitiesImplementations(this.defaultActivitiesTaskListToPoll, activitiesImplementationObjects);
    }

    public void setTaskListActivitiesImplementationMap(Map<String, Object> map) {
        this.workers.clear();
        for (Map.Entry<String, Object> taskImplPair : map.entrySet()) {
            this.addActivitiesImplementation(taskImplPair.getKey(), taskImplPair.getValue());
        }
    }

    public Map<String, Object> getTaskListActivitiesImplementationMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, TestPOJOActivityImplementationWorker> pair : this.workers.entrySet()) {
            Iterable<Object> implementations = pair.getValue().getActivitiesImplementations();
            for (Object impelementation : implementations) {
                result.put(pair.getKey(), impelementation);
            }
        }
        return result;
    }

    public void addActivitiesImplementations(String taskList, Iterable<Object> activityImplementationObjects) {
        try {
            TestPOJOActivityImplementationWorker worker = this.getActivityWorker(taskList);
            worker.addActivitiesImplementations(activityImplementationObjects);
            this.activityClient.addWorker(worker);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid activities implementation: " + activityImplementationObjects, e);
        }
    }

    public Iterable<Object> getActivitiesImplementations() {
        TestPOJOActivityImplementationWorker worker = this.getActivityWorker(this.defaultActivitiesTaskListToPoll);
        return worker.getActivitiesImplementations();
    }

    public void setWorkflowImplementationTypes(Collection<Class<?>> workflowImplementationTypes) throws InstantiationException, IllegalAccessException {
        this.workflowClient.setWorkflowImplementationTypes(workflowImplementationTypes);
    }
}

