/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteItemRequestMarshaller
implements Marshaller<Request<DeleteItemRequest>, DeleteItemRequest> {
    @Override
    public Request<DeleteItemRequest> marshall(DeleteItemRequest deleteItemRequest) {
        if (deleteItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteItemRequest> request = new DefaultRequest<DeleteItemRequest>(deleteItemRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.DeleteItem";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (deleteItemRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(deleteItemRequest.getTableName());
            }
            if (deleteItemRequest.getKey() != null) {
                jsonWriter.key("Key");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValue> keyListValue : deleteItemRequest.getKey().entrySet()) {
                    ListWithAutoConstructFlag bSList;
                    ListWithAutoConstructFlag nSList;
                    ListWithAutoConstructFlag sSList;
                    if (keyListValue.getValue() == null) continue;
                    jsonWriter.key(keyListValue.getKey());
                    jsonWriter.object();
                    if (keyListValue.getValue().getS() != null) {
                        jsonWriter.key("S").value(keyListValue.getValue().getS());
                    }
                    if (keyListValue.getValue().getN() != null) {
                        jsonWriter.key("N").value(keyListValue.getValue().getN());
                    }
                    if (keyListValue.getValue().getB() != null) {
                        jsonWriter.key("B").value(keyListValue.getValue().getB());
                    }
                    if (!((sSList = (ListWithAutoConstructFlag)keyListValue.getValue().getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                        jsonWriter.key("SS");
                        jsonWriter.array();
                        for (String sSListValue : sSList) {
                            if (sSListValue == null) continue;
                            jsonWriter.value(sSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((nSList = (ListWithAutoConstructFlag)keyListValue.getValue().getNS()) == null || nSList.isAutoConstruct() && nSList.isEmpty())) {
                        jsonWriter.key("NS");
                        jsonWriter.array();
                        for (String nSListValue : nSList) {
                            if (nSListValue == null) continue;
                            jsonWriter.value(nSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((bSList = (ListWithAutoConstructFlag)keyListValue.getValue().getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                        jsonWriter.key("BS");
                        jsonWriter.array();
                        for (ByteBuffer bSListValue : bSList) {
                            if (bSListValue == null) continue;
                            jsonWriter.value(bSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (deleteItemRequest.getExpected() != null) {
                jsonWriter.key("Expected");
                jsonWriter.object();
                for (Map.Entry<String, ExpectedAttributeValue> expectedListValue : deleteItemRequest.getExpected().entrySet()) {
                    if (expectedListValue.getValue() == null) continue;
                    jsonWriter.key(expectedListValue.getKey());
                    jsonWriter.object();
                    AttributeValue value = expectedListValue.getValue().getValue();
                    if (value != null) {
                        ListWithAutoConstructFlag bSList;
                        ListWithAutoConstructFlag nSList;
                        ListWithAutoConstructFlag sSList;
                        jsonWriter.key("Value");
                        jsonWriter.object();
                        if (value.getS() != null) {
                            jsonWriter.key("S").value(value.getS());
                        }
                        if (value.getN() != null) {
                            jsonWriter.key("N").value(value.getN());
                        }
                        if (value.getB() != null) {
                            jsonWriter.key("B").value(value.getB());
                        }
                        if (!((sSList = (ListWithAutoConstructFlag)value.getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                            jsonWriter.key("SS");
                            jsonWriter.array();
                            for (String sSListValue : sSList) {
                                if (sSListValue == null) continue;
                                jsonWriter.value(sSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((nSList = (ListWithAutoConstructFlag)value.getNS()) == null || nSList.isAutoConstruct() && nSList.isEmpty())) {
                            jsonWriter.key("NS");
                            jsonWriter.array();
                            for (String nSListValue : nSList) {
                                if (nSListValue == null) continue;
                                jsonWriter.value(nSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((bSList = (ListWithAutoConstructFlag)value.getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                            jsonWriter.key("BS");
                            jsonWriter.array();
                            for (ByteBuffer bSListValue : bSList) {
                                if (bSListValue == null) continue;
                                jsonWriter.value(bSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    if (expectedListValue.getValue().isExists() != null) {
                        jsonWriter.key("Exists").value(expectedListValue.getValue().isExists());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (deleteItemRequest.getReturnValues() != null) {
                jsonWriter.key("ReturnValues").value(deleteItemRequest.getReturnValues());
            }
            if (deleteItemRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value(deleteItemRequest.getReturnConsumedCapacity());
            }
            if (deleteItemRequest.getReturnItemCollectionMetrics() != null) {
                jsonWriter.key("ReturnItemCollectionMetrics").value(deleteItemRequest.getReturnItemCollectionMetrics());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

