/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iotdmp.model.service.rulechain;

import com.baidubce.services.iotdmp.model.service.rulechain.BlinkDataPermission;
import com.baidubce.services.iotdmp.model.service.rulechain.BlinkDataType;
import com.baidubce.services.iotdmp.model.service.rulechain.MessageType;

public enum BlinkTopicInfo {
    PROPERTY_POST("\u5c5e\u6027\u4e0a\u62a5", "\u8bbe\u5907\u5c5e\u6027\u72b6\u6001\u5355\u6b21\u4e0a\u62a5", "thing/%s/%s/property/post", MessageType.DEVICE_MESSAGE, BlinkDataType.DEVICE_MESSAGE, BlinkDataPermission.UPWARD),
    PROPERTY_BATCH("\u5c5e\u6027\u4e0a\u62a5", "\u8bbe\u5907\u5c5e\u6027\u72b6\u6001\u6279\u91cf\u4e0a\u62a5", "thing/%s/%s/property/batch", MessageType.DEVICE_MESSAGE, BlinkDataType.DEVICE_MESSAGE, BlinkDataPermission.UPWARD),
    PROPERTY_UPLOAD("\u5c5e\u6027\u4e0a\u62a5", "\u8bbe\u5907\u5c5e\u6027\u6279\u91cf\u4e0a\u4f20", "thing/%s/%s/property/upload", MessageType.DEVICE_MESSAGE, BlinkDataType.DEVICE_MESSAGE, BlinkDataPermission.UPWARD),
    PROPERTY_DESIRED("\u5c5e\u6027\u4e0a\u62a5", "\u66f4\u65b0\u8bbe\u5907\u671f\u671b\u503c", "thing/%s/%s/property/desired", MessageType.DEVICE_MESSAGE, BlinkDataType.DEVICE_MESSAGE, BlinkDataPermission.UPWARD),
    PROPERTY_GET("\u6570\u636e\u8bf7\u6c42", "\u8bf7\u6c42\u8bbe\u5907\u5f71\u5b50\u6570\u636e", "thing/%s/%s/property/get", MessageType.DEVICE_MESSAGE, BlinkDataType.DEVICE_MESSAGE, BlinkDataPermission.UPWARD),
    PROPERTY_SNAPSHOT("\u6570\u636e\u4e0b\u53d1", "\u8bbe\u5907\u5f71\u5b50\u6570\u636e\u4e0b\u53d1", "thing/%s/%s/property/snapshot", MessageType.DEVICE_MESSAGE, BlinkDataType.DEVICE_MESSAGE, BlinkDataPermission.DOWNWARD),
    PROPERTY_DELTA("\u6570\u636e\u4e0b\u53d1", "\u8bbe\u5907\u5f71\u5b50\u6570\u636e\u4e0e\u671f\u671b\u503c\u5dee\u5f02", "thing/%s/%s/property/delta", MessageType.DEVICE_MESSAGE, BlinkDataType.DEVICE_MESSAGE, BlinkDataPermission.SYSTEM),
    PROPERTY_DELETE("\u6570\u636e\u8bf7\u6c42", "\u6e05\u7a7a\u8bbe\u5907\u5f71\u5b50\u6570\u636e", "thing/%s/%s/property/delete", MessageType.DEVICE_MESSAGE, BlinkDataType.DEVICE_MESSAGE, BlinkDataPermission.UPWARD),
    EVENT_POST("\u4e8b\u4ef6\u4e0a\u62a5", "\u8bbe\u5907\u4e8b\u4ef6\u5355\u6b21\u4e0a\u62a5", "thing/%s/%s/event/post", MessageType.DEVICE_MESSAGE, BlinkDataType.DEVICE_MESSAGE, BlinkDataPermission.UPWARD),
    EVENT_BATCH("\u4e8b\u4ef6\u4e0a\u62a5", "\u8bbe\u5907\u4e8b\u4ef6\u6279\u91cf\u4e0a\u62a5", "thing/%s/%s/event/batch", MessageType.DEVICE_MESSAGE, BlinkDataType.DEVICE_MESSAGE, BlinkDataPermission.UPWARD),
    EVENT_UPLOAD("\u4e8b\u4ef6\u4e0a\u62a5", "\u8bbe\u5907\u4e8b\u4ef6\u6279\u91cf\u4e0a\u4f20", "thing/%s/%s/event/upload", MessageType.DEVICE_MESSAGE, BlinkDataType.DEVICE_MESSAGE, BlinkDataPermission.UPWARD),
    PROPERTY_INVOKE("\u5c5e\u6027\u4e0b\u53d1", "\u8bbe\u5907\u53ef\u5199\u5c5e\u6027\u66f4\u65b0", "thing/%s/%s/property/invoke", MessageType.DEVICE_MESSAGE, BlinkDataType.DEVICE_MESSAGE, BlinkDataPermission.DOWNWARD),
    COMMAND_INVOKE("\u670d\u52a1\u8c03\u7528", "\u8bbe\u5907\u670d\u52a1\u8c03\u7528", "thing/%s/%s/command/invoke", MessageType.DEVICE_MESSAGE, BlinkDataType.DEVICE_MESSAGE, BlinkDataPermission.DOWNWARD),
    CLOUD_TO_DEVICE("\u4e91\u7aef\u54cd\u5e94", "\u8bbe\u5907\u7aef\u8c03\u7528\u4e91\u7aef\u54cd\u5e94", "thing/%s/%s/response/c2d", MessageType.DEVICE_MESSAGE, BlinkDataType.DEVICE_MESSAGE, BlinkDataPermission.DOWNWARD),
    DEVICE_TO_CLOUD("\u8bbe\u5907\u54cd\u5e94", "\u4e91\u7aef\u8c03\u7528\u8bbe\u5907\u7aef\u54cd\u5e94", "thing/%s/%s/response/d2c", MessageType.DEVICE_MESSAGE, BlinkDataType.DEVICE_MESSAGE, BlinkDataPermission.UPWARD),
    LIFECYCLE_UPDATE("\u751f\u547d\u5468\u671f", "\u8bbe\u5907\u751f\u547d\u5468\u671f\u53d8\u66f4", "thing/%s/%s/lifecycle/update", MessageType.DEVICE_STATE_CHANGE, BlinkDataType.DEVICE_STATE_CHANGE, BlinkDataPermission.SYSTEM);

    private String commonName;
    private String description;
    private String pattern;
    private MessageType messageType;
    private BlinkDataType dataType;
    private BlinkDataPermission permission;

    public boolean isSourceable() {
        return this.permission.equals((Object)BlinkDataPermission.UPWARD) || this.permission.equals((Object)BlinkDataPermission.SYSTEM);
    }

    public boolean isSinkable() {
        return this.permission.equals((Object)BlinkDataPermission.DOWNWARD);
    }

    private BlinkTopicInfo(String commonName, String description, String pattern, MessageType messageType, BlinkDataType dataType, BlinkDataPermission permission) {
        this.commonName = commonName;
        this.description = description;
        this.pattern = pattern;
        this.messageType = messageType;
        this.dataType = dataType;
        this.permission = permission;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPattern() {
        return this.pattern;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public BlinkDataType getDataType() {
        return this.dataType;
    }

    public BlinkDataPermission getPermission() {
        return this.permission;
    }
}

