/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format.formatter;

import com.cosium.code.format.formatter.CodeFormatter;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;

public class JavaFormatter
implements CodeFormatter {
    private static final String JAVA_EXTENSION = ".java";
    private final Supplier<Log> log;

    public JavaFormatter(Supplier<Log> log) {
        this.log = log;
    }

    private boolean isJavaFile(Path file) {
        return file.toString().endsWith(JAVA_EXTENSION);
    }

    @Override
    public void format(Path file) {
        String formattedContent;
        if (!this.isJavaFile(file)) {
            this.log.get().debug((CharSequence)(file + " is not a java file"));
            return;
        }
        if (!Files.exists(file, new LinkOption[0])) {
            this.log.get().debug((CharSequence)(file + " doesn't exist"));
            return;
        }
        this.log.get().info((CharSequence)("Formatting '" + file + "'"));
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            formattedContent = new Formatter().formatSourceAndFixImports(IOUtils.toString((InputStream)inputStream, (String)"UTF-8"));
        }
        catch (FormatterException | IOException e) {
            throw new RuntimeException(e);
        }
        try (OutputStream outputStream = Files.newOutputStream(file, StandardOpenOption.TRUNCATE_EXISTING);){
            IOUtils.write((String)formattedContent, (OutputStream)outputStream, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.log.get().info((CharSequence)("Formatted '" + file + "'"));
    }

    @Override
    public boolean validate(Path file) {
        boolean bl;
        block9: {
            if (!this.isJavaFile(file)) {
                this.log.get().debug((CharSequence)(file + " is not a java file"));
                return true;
            }
            this.log.get().info((CharSequence)("Validating '" + file + "'"));
            InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
            try {
                String unformatterContent = IOUtils.toString((InputStream)inputStream);
                String formattedContent = new Formatter().formatSourceAndFixImports(unformatterContent);
                bl = unformatterContent.equals(formattedContent);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FormatterException | IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return bl;
    }
}

