/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u00015\u00111#T;mi&\u0004H.\u001a*fiJL\bk\u001c7jGfT!a\u0001\u0003\u0002\u0007\r\fHN\u0003\u0002\u0006\r\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\u0011\u0011\fG/Y:uCbT\u0011aC\u0001\u0004G>l7\u0001A\n\u0004\u000191\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]qR\"\u0001\r\u000b\u0005eQ\u0012\u0001\u00039pY&\u001c\u0017.Z:\u000b\u0005ma\u0012\u0001B2pe\u0016T!!\b\u0005\u0002\r\u0011\u0014\u0018N^3s\u0013\ty\u0002DA\u0006SKR\u0014\u0018\u0010U8mS\u000eL\b\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\u001b5\f\u0007PU3uef\u001cu.\u001e8u!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\rIe\u000e\u001e\u0005\tS\u0001\u0011\t\u0011)A\u0005U\u0005Q!/\u001a;ss\u0012+G.Y=\u0011\u0005-zcB\u0001\u0017.\u001b\u0005\u0011\u0011B\u0001\u0018\u0003\u0003Y\u0019\u0015m]:b]\u0012\u0014\u0018mQ8o]\u0016\u001cGo\u001c:D_:4\u0017B\u0001\u00192\u00059\u0011V\r\u001e:z\t\u0016d\u0017-_\"p]\u001aT!A\f\u0002\t\u000bM\u0002A\u0011\u0001\u001b\u0002\rqJg.\u001b;?)\r)dg\u000e\t\u0003Y\u0001AQ!\t\u001aA\u0002\tBQ!\u000b\u001aA\u0002)BQ!\u000f\u0001\u0005\ni\nAB]3uef|%\u000f\u00165s_^$2aO(V!\taDJ\u0004\u0002>\u0015:\u0011a(\u0013\b\u0003\u007f!s!\u0001Q$\u000f\u0005\u00053eB\u0001\"F\u001b\u0005\u0019%B\u0001#\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011Q\u0004C\u0005\u00037qI!!\u0007\u000e\n\u0005-C\u0012a\u0003*fiJL\bk\u001c7jGfL!!\u0014(\u0003\u001bI+GO]=EK\u000eL7/[8o\u0015\tY\u0005\u0004C\u0003Qq\u0001\u0007\u0011+\u0001\u0002dYB\u0011!kU\u0007\u00025%\u0011AK\u0007\u0002\u0011\u0007>t7/[:uK:\u001c\u0017\u0010T3wK2DQA\u0016\u001dA\u0002\t\nqA\u001c2SKR\u0014\u0018\u0010C\u0003Y\u0001\u0011\u0005\u0013,\u0001\u0003j]&$HC\u0001.^!\t\u00193,\u0003\u0002]I\t!QK\\5u\u0011\u0015qv\u000b1\u0001`\u0003\u001d\u0019G.^:uKJ\u0004\"A\u00151\n\u0005\u0005T\"aB\"mkN$XM\u001d\u0005\u0006G\u0002!\t\u0005Z\u0001\u0006G2|7/\u001a\u000b\u00025\")a\r\u0001C!O\u0006iqN\u001c*fC\u0012$\u0016.\\3pkR$ra\u000f5n]B\u0014x\u000fC\u0003jK\u0002\u0007!.\u0001\u0003ti6$\bC\u0001*l\u0013\ta'DA\u0005Ti\u0006$X-\\3oi\")\u0001+\u001aa\u0001#\")q.\u001aa\u0001E\u0005\t\"/Z9vSJ,GMU3ta>t7/Z:\t\u000bE,\u0007\u0019\u0001\u0012\u0002#I,7-Z5wK\u0012\u0014Vm\u001d9p]N,7\u000fC\u0003tK\u0002\u0007A/A\u0007eCR\f'+\u001a;sS\u00164X\r\u001a\t\u0003GUL!A\u001e\u0013\u0003\u000f\t{w\u000e\\3b]\")a+\u001aa\u0001E!)\u0011\u0010\u0001C!u\u0006iqN\\+oCZ\f\u0017\u000e\\1cY\u0016$raO>}{~\f\u0019\u0001C\u0003jq\u0002\u0007!\u000eC\u0003Qq\u0002\u0007\u0011\u000bC\u0003\u007fq\u0002\u0007!%A\bsKF,\u0018N]3e%\u0016\u0004H.[2b\u0011\u0019\t\t\u0001\u001fa\u0001E\u0005a\u0011\r\\5wKJ+\u0007\u000f\\5dC\")a\u000b\u001fa\u0001E!9\u0011q\u0001\u0001\u0005B\u0005%\u0011AD8o/JLG/\u001a+j[\u0016|W\u000f\u001e\u000b\u000ew\u0005-\u0011QBA\b\u00033\ti\"!\t\t\r%\f)\u00011\u0001k\u0011\u0019\u0001\u0016Q\u0001a\u0001#\"A\u0011\u0011CA\u0003\u0001\u0004\t\u0019\"A\u0005xe&$X\rV=qKB\u0019!+!\u0006\n\u0007\u0005]!DA\u0005Xe&$X\rV=qK\"9\u00111DA\u0003\u0001\u0004\u0011\u0013\u0001\u0004:fcVL'/\u001a3BG.\u001c\bbBA\u0010\u0003\u000b\u0001\rAI\u0001\re\u0016\u001cW-\u001b<fI\u0006\u001b7n\u001d\u0005\u0007-\u0006\u0015\u0001\u0019\u0001\u0012\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(\u0005qqN\u001c*fcV,7\u000f^#se>\u0014H#C\u001e\u0002*\u0005-\u0012QFA\u001f\u0011\u0019I\u00171\u0005a\u0001U\"1\u0001+a\tA\u0002EC\u0001\"a\f\u0002$\u0001\u0007\u0011\u0011G\u0001\u0003Kb\u0004B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003oQ\u0012AC3yG\u0016\u0004H/[8og&!\u00111HA\u001b\u0005=!%/\u001b<fe\u0016C8-\u001a9uS>t\u0007B\u0002,\u0002$\u0001\u0007!\u0005")
public class MultipleRetryPolicy
implements RetryPolicy {
    private final int maxRetryCount;
    private final CassandraConnectorConf.RetryDelayConf retryDelay;

    private RetryPolicy.RetryDecision retryOrThrow(ConsistencyLevel cl, int nbRetry) {
        RetryPolicy.RetryDecision retryDecision;
        if (nbRetry < this.maxRetryCount) {
            long delay;
            if (nbRetry > 0 && (delay = this.retryDelay.forRetry(nbRetry).toMillis()) > 0L) {
                Thread.sleep(delay);
            }
            retryDecision = RetryPolicy.RetryDecision.retry((ConsistencyLevel)cl);
        } else {
            retryDecision = RetryPolicy.RetryDecision.rethrow();
        }
        return retryDecision;
    }

    public void init(Cluster cluster) {
    }

    public void close() {
    }

    public RetryPolicy.RetryDecision onReadTimeout(Statement stmt, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
        return this.retryOrThrow(cl, nbRetry);
    }

    public RetryPolicy.RetryDecision onUnavailable(Statement stmt, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
        return this.retryOrThrow(cl, nbRetry);
    }

    public RetryPolicy.RetryDecision onWriteTimeout(Statement stmt, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
        return this.retryOrThrow(cl, nbRetry);
    }

    public RetryPolicy.RetryDecision onRequestError(Statement stmt, ConsistencyLevel cl, DriverException ex, int nbRetry) {
        return this.retryOrThrow(cl, nbRetry);
    }

    public MultipleRetryPolicy(int maxRetryCount, CassandraConnectorConf.RetryDelayConf retryDelay) {
        this.maxRetryCount = maxRetryCount;
        this.retryDelay = retryDelay;
    }
}

