/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.rdd.partitioner.ReplicaPartition;
import com.datastax.spark.connector.rdd.partitioner.ReplicaPartitioner$;
import java.net.InetAddress;
import java.util.Random;
import org.apache.spark.Partition;
import org.apache.spark.Partitioner;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u0001=\u0011!CU3qY&\u001c\u0017\rU1si&$\u0018n\u001c8fe*\u00111\u0001B\u0001\fa\u0006\u0014H/\u001b;j_:,'O\u0003\u0002\u0006\r\u0005\u0019!\u000f\u001a3\u000b\u0005\u001dA\u0011!C2p]:,7\r^8s\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u0005AA-\u0019;bgR\f\u0007PC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012/5\t!C\u0003\u0002\n')\u0011A#F\u0001\u0007CB\f7\r[3\u000b\u0003Y\t1a\u001c:h\u0013\tA\"CA\u0006QCJ$\u0018\u000e^5p]\u0016\u0014\b\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002/A\f'\u000f^5uS>t7\u000fU3s%\u0016\u0004H.[2b'\u0016$\bC\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"aA%oi\"Aq\u0001\u0001BC\u0002\u0013\u0005!%F\u0001$!\t!s%D\u0001&\u0015\t1c!A\u0002dc2L!\u0001K\u0013\u0003%\r\u000b7o]1oIJ\f7i\u001c8oK\u000e$xN\u001d\u0005\tU\u0001\u0011\t\u0011)A\u0005G\u0005Q1m\u001c8oK\u000e$xN\u001d\u0011\t\u000b1\u0002A\u0011A\u0017\u0002\rqJg.\u001b;?)\rq\u0003'\r\t\u0003_\u0001i\u0011A\u0001\u0005\u00065-\u0002\ra\u0007\u0005\u0006\u000f-\u0002\ra\t\u0005\bg\u0001\u0011\r\u0011\"\u00035\u0003\u0015Awn\u001d;t+\u0005)\u0004c\u0001\u001c?\u0003:\u0011q\u0007\u0010\b\u0003qmj\u0011!\u000f\u0006\u0003u9\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0010\n\u0005uj\u0012a\u00029bG.\fw-Z\u0005\u0003\u007f\u0001\u0013aAV3di>\u0014(BA\u001f\u001e!\t\u0011u)D\u0001D\u0015\t!U)A\u0002oKRT\u0011AR\u0001\u0005U\u00064\u0018-\u0003\u0002I\u0007\nY\u0011J\\3u\u0003\u0012$'/Z:t\u0011\u0019Q\u0005\u0001)A\u0005k\u00051\u0001n\\:ug\u0002Bq\u0001\u0014\u0001C\u0002\u0013%Q*\u0001\u0005ok6Dun\u001d;t+\u0005Y\u0002BB(\u0001A\u0003%1$A\u0005ok6Dun\u001d;tA!9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0016\u0001\u00059beRLG/[8o\u0013:$W\r_3t+\u0005\u0019\u0006c\u0001\u001cU-&\u0011Q\u000b\u0011\u0002\u0005\u0019&\u001cH\u000fE\u0002X9ni\u0011\u0001\u0017\u0006\u00033j\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005mk\u0012AC2pY2,7\r^5p]&\u0011Q\f\u0017\u0002\u000b\u0013:$W\r_3e'\u0016\f\bBB0\u0001A\u0003%1+A\tqCJ$\u0018\u000e^5p]&sG-\u001a=fg\u0002Bq!\u0019\u0001C\u0002\u0013%!-A\u0004i_N$X*\u00199\u0016\u0003\r\u0004Ba\u00163B-&\u0011Q\r\u0017\u0002\u0004\u001b\u0006\u0004\bBB4\u0001A\u0003%1-\u0001\u0005i_N$X*\u00199!\u0011\u001dI\u0007A1A\u0005\n)\f\u0001\"\u001b8eKbl\u0015\r]\u000b\u0002WB!q\u000bZ\u000eB\u0011\u0019i\u0007\u0001)A\u0005W\u0006I\u0011N\u001c3fq6\u000b\u0007\u000f\t\u0005\b_\u0002\u0011\r\u0011\"\u0003q\u0003\u0011\u0011\u0018M\u001c3\u0016\u0003E\u0004\"A];\u000e\u0003MT!\u0001^#\u0002\tU$\u0018\u000e\\\u0005\u0003mN\u0014aAU1oI>l\u0007B\u0002=\u0001A\u0003%\u0011/A\u0003sC:$\u0007\u0005C\u0003{\u0001\u0011%10\u0001\u0006sC:$w.\u001c%pgR,\u0012!\u0011\u0005\u0006{\u0002!\tE`\u0001\rO\u0016$\b+\u0019:uSRLwN\u001c\u000b\u00037}Dq!!\u0001}\u0001\u0004\t\u0019!A\u0002lKf\u00042\u0001HA\u0003\u0013\r\t9!\b\u0002\u0004\u0003:L\bBBA\u0006\u0001\u0011\u0005S*A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0003Q9W\r^#oIB|\u0017N\u001c;QCJ$\u0018\u000e^5p]R!\u00111CA\r!\ry\u0013QC\u0005\u0004\u0003/\u0011!\u0001\u0005*fa2L7-\u0019)beRLG/[8o\u0011!\tY\"!\u0004A\u0002\u0005u\u0011!\u00039beRLG/[8o!\r\t\u0012qD\u0005\u0004\u0003C\u0011\"!\u0003)beRLG/[8o\u0001")
public class ReplicaPartitioner
extends Partitioner {
    private final int partitionsPerReplicaSet;
    private final CassandraConnector connector;
    private final Vector<InetAddress> hosts;
    private final int numHosts;
    private final List<IndexedSeq<Object>> partitionIndexes;
    private final Map<InetAddress, IndexedSeq<Object>> hostMap;
    private final Map<Object, InetAddress> com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap;
    private final Random rand;

    public CassandraConnector connector() {
        return this.connector;
    }

    private Vector<InetAddress> hosts() {
        return this.hosts;
    }

    private int numHosts() {
        return this.numHosts;
    }

    private List<IndexedSeq<Object>> partitionIndexes() {
        return this.partitionIndexes;
    }

    private Map<InetAddress, IndexedSeq<Object>> hostMap() {
        return this.hostMap;
    }

    public Map<Object, InetAddress> com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap() {
        return this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap;
    }

    private Random rand() {
        return this.rand;
    }

    private InetAddress randomHost() {
        return (InetAddress)this.hosts().apply(this.rand().nextInt(this.numHosts()));
    }

    public int getPartition(Object key) {
        Set set;
        Object object = key;
        if (object instanceof Set && (set = (Set)object).size() > 0 && set.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object x$2) {
                return x$2 instanceof InetAddress;
            }
        })) {
            int n;
            Vector replicaSetInDC = ((TraversableOnce)this.hosts().toSet().$amp((GenSet)set)).toVector();
            if (replicaSetInDC.nonEmpty()) {
                InetAddress endpoint = (InetAddress)replicaSetInDC.apply(this.rand().nextInt(replicaSetInDC.size()));
                n = BoxesRunTime.unboxToInt((Object)((SeqLike)this.hostMap().apply((Object)endpoint)).apply(this.rand().nextInt(this.partitionsPerReplicaSet)));
            } else {
                n = BoxesRunTime.unboxToInt((Object)((SeqLike)this.hostMap().apply((Object)this.randomHost())).apply(this.rand().nextInt(this.partitionsPerReplicaSet)));
            }
            int n2 = n;
            return n2;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"ReplicaPartitioner can only determine the partition of a tuple whose key is a non-empty Set[InetAddress]. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}))).toString());
    }

    public int numPartitions() {
        return this.partitionsPerReplicaSet * this.numHosts();
    }

    public ReplicaPartition getEndpointPartition(Partition partition) {
        InetAddress endpoints = (InetAddress)this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap().getOrElse((Object)BoxesRunTime.boxToInteger((int)partition.index()), (Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaPartitioner $outer;
            private final Partition partition$1;

            public final Nothing$ apply() {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " : Can't get an endpoint for Partition ", ".index"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap(), this.partition$1})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
            }
        });
        return new ReplicaPartition(partition.index(), (Set<InetAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{endpoints}))));
    }

    public ReplicaPartitioner(int partitionsPerReplicaSet, CassandraConnector connector) {
        this.partitionsPerReplicaSet = partitionsPerReplicaSet;
        this.connector = connector;
        this.hosts = connector.hosts().toVector();
        this.numHosts = this.hosts().size();
        this.partitionIndexes = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionsPerReplicaSet * this.numHosts()).grouped(partitionsPerReplicaSet).toList();
        this.hostMap = ((TraversableOnce)this.hosts().zip(this.partitionIndexes(), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap = (Map)this.hostMap().withFilter((Function1)new $anonfun$1(this)).flatMap((Function1)new $anonfun$2(this), Map$.MODULE$.canBuildFrom());
        this.rand = new Random();
    }
}

