/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import java.util.HashMap;
import java.util.Map;
import smile.data.Attribute;
import smile.data.NominalAttribute;
import smile.data.NumericAttribute;
import smile.feature.FeatureGenerator;

public class Bag<T>
implements FeatureGenerator<T[]> {
    private Attribute[] attributes;
    private Map<T, Integer> features;
    private boolean binary;

    public Bag(T[] features) {
        this(features, false);
    }

    public Bag(T[] features, boolean binary) {
        this.binary = binary;
        this.features = new HashMap<T, Integer>();
        int k = 0;
        for (int i = 0; i < features.length; ++i) {
            if (this.features.containsKey(features[i])) continue;
            this.features.put(features[i], k++);
        }
        this.attributes = new Attribute[this.features.size()];
        for (Map.Entry<T, Integer> entry : this.features.entrySet()) {
            if (binary) {
                this.attributes[entry.getValue().intValue()] = new NominalAttribute(entry.getKey().toString(), new String[]{"No", "Yes"});
                continue;
            }
            this.attributes[entry.getValue().intValue()] = new NumericAttribute(entry.getKey().toString());
        }
    }

    @Override
    public Attribute[] attributes() {
        return this.attributes;
    }

    @Override
    public double[] feature(T[] x) {
        double[] bag = new double[this.features.size()];
        if (this.binary) {
            for (T word : x) {
                Integer f = this.features.get(word);
                if (f == null) continue;
                bag[f.intValue()] = 1.0;
            }
        } else {
            for (T word : x) {
                Integer f = this.features.get(word);
                if (f == null) continue;
                int n = f;
                bag[n] = bag[n] + 1.0;
            }
        }
        return bag;
    }
}

