/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.Attribute;
import smile.feature.FeatureTransform;
import smile.math.Math;

public class Normalizer
extends FeatureTransform {
    private static final Logger logger = LoggerFactory.getLogger(Normalizer.class);
    private Norm norm = Norm.L2;

    public Normalizer() {
    }

    public Normalizer(boolean copy) {
        super(copy);
    }

    public Normalizer(Norm norm) {
        this.norm = norm;
    }

    public Normalizer(Norm norm, boolean copy) {
        super(copy);
        this.norm = norm;
    }

    @Override
    public void learn(Attribute[] attributes, double[][] data) {
        logger.info("Normalizer is stateless and learn() does nothing.");
    }

    @Override
    public double[] transform(double[] x) {
        double[] y;
        double scale;
        switch (this.norm) {
            case L1: {
                scale = Math.norm1((double[])x);
                break;
            }
            case L2: {
                scale = Math.norm2((double[])x);
                break;
            }
            case Inf: {
                scale = Math.normInf((double[])x);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type of norm: " + (Object)((Object)this.norm));
            }
        }
        double[] dArray = y = this.copy ? new double[x.length] : x;
        if (Math.isZero((double)scale)) {
            if (y != x) {
                System.arraycopy(x, 0, y, 0, x.length);
            }
        } else {
            for (int i = 0; i < x.length; ++i) {
                y[i] = x[i] / scale;
            }
        }
        return y;
    }

    public String toString() {
        return "Normalizer()";
    }

    public static enum Norm {
        L1,
        L2,
        Inf;

    }
}

