/*
 * Decompiled with CFR 0.152.
 */
package smile.imputation;

import smile.imputation.MissingValueImputation;
import smile.imputation.MissingValueImputationException;
import smile.sort.QuickSort;

public class KNNImputation
implements MissingValueImputation {
    private int k;

    public KNNImputation(int k) {
        if (k < 1) {
            throw new IllegalArgumentException("Invalid number of nearest neighbors for imputation: " + k);
        }
        this.k = k;
    }

    @Override
    public void impute(double[][] data) throws MissingValueImputationException {
        int i;
        int[] count = new int[data[0].length];
        for (i = 0; i < data.length; ++i) {
            int n = 0;
            for (int j = 0; j < data[i].length; ++j) {
                if (!Double.isNaN(data[i][j])) continue;
                ++n;
                int n2 = j;
                count[n2] = count[n2] + 1;
            }
            if (n != data[i].length) continue;
            throw new MissingValueImputationException("The whole row " + i + " is missing");
        }
        for (i = 0; i < data[0].length; ++i) {
            if (count[i] != data.length) continue;
            throw new MissingValueImputationException("The whole column " + i + " is missing");
        }
        double[] dist = new double[data.length];
        for (int i2 = 0; i2 < data.length; ++i2) {
            int m;
            int n;
            int j;
            double[] x = data[i2];
            int missing = 0;
            for (j = 0; j < x.length; ++j) {
                if (!Double.isNaN(x[j])) continue;
                ++missing;
            }
            if (missing == 0) continue;
            for (j = 0; j < data.length; ++j) {
                double[] y = data[j];
                n = 0;
                dist[j] = 0.0;
                for (m = 0; m < x.length; ++m) {
                    if (Double.isNaN(x[m]) || Double.isNaN(y[m])) continue;
                    ++n;
                    double d = x[m] - y[m];
                    int n3 = j;
                    dist[n3] = dist[n3] + d * d;
                }
                dist[j] = n > (x.length - missing) / 2 ? (double)x.length * dist[j] / (double)n : Double.MAX_VALUE;
            }
            double[][] dat = new double[data.length][];
            System.arraycopy(data, 0, dat, 0, data.length);
            QuickSort.sort((double[])dist, (Object[])dat);
            for (int j2 = 0; j2 < data[i2].length; ++j2) {
                if (!Double.isNaN(x[j2])) continue;
                x[j2] = 0.0;
                n = 0;
                for (m = 0; n < this.k && m < dat.length; ++m) {
                    if (Double.isNaN(dat[m][j2])) continue;
                    int n4 = j2;
                    x[n4] = x[n4] + dat[m][j2];
                    ++n;
                }
                int n5 = j2;
                x[n5] = x[n5] / (double)n;
            }
        }
    }
}

