/*
 * Decompiled with CFR 0.152.
 */
package smile.data.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.ParseException;
import smile.data.SparseDataset;

public class SparseDatasetParser {
    private int arrayIndexOrigin = 0;

    public SparseDatasetParser() {
    }

    public SparseDatasetParser(int arrayIndexOrigin) {
        this.arrayIndexOrigin = arrayIndexOrigin;
    }

    public SparseDataset parse(URI uri) throws IOException, ParseException {
        return this.parse(new File(uri));
    }

    public SparseDataset parse(String name, URI uri) throws IOException, ParseException {
        return this.parse(name, new File(uri));
    }

    public SparseDataset parse(String path) throws IOException, ParseException {
        return this.parse(new File(path));
    }

    public SparseDataset parse(String name, String path) throws IOException, ParseException {
        return this.parse(name, new File(path));
    }

    public SparseDataset parse(File file) throws IOException, ParseException {
        String name = file.getPath();
        return this.parse(name, new FileInputStream(file));
    }

    public SparseDataset parse(String name, File file) throws IOException, ParseException {
        return this.parse(name, new FileInputStream(file));
    }

    public SparseDataset parse(InputStream stream) throws IOException, ParseException {
        return this.parse("Sparse Dataset", stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparseDataset parse(String name, InputStream stream) throws IOException, ParseException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String[] tokens;
            int nrow;
            String line = reader.readLine();
            for (nrow = 1; nrow <= 3 && line != null && (tokens = line.trim().split(" ")).length < 3; ++nrow) {
                line = reader.readLine();
            }
            if (line == null) {
                throw new IOException("Empty data source.");
            }
            SparseDataset sparse = new SparseDataset(name);
            do {
                String[] tokens2;
                if ((tokens2 = line.trim().split(" ")).length != 3) {
                    throw new ParseException("Invalid number of tokens.", nrow);
                }
                int d = Integer.parseInt(tokens2[0]) - this.arrayIndexOrigin;
                int w = Integer.parseInt(tokens2[1]) - this.arrayIndexOrigin;
                double c = Double.parseDouble(tokens2[2]);
                sparse.set(d, w, c);
                line = reader.readLine();
                ++nrow;
            } while (line != null);
            SparseDataset sparseDataset = sparse;
            return sparseDataset;
        }
    }
}

