/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.set.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.set.primitive.MutableBooleanSet;

/**
 * A factory which creates instances of type {@link MutableBooleanSet}.
 * This file was automatically generated from template file mutablePrimitiveSetFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableBooleanSetFactory
{
    MutableBooleanSet empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableBooleanSet of();

    /**
     * Same as {@link #empty()}.
     */
    MutableBooleanSet with();

    /**
     * Same as {@link #with(boolean[])}.
     */
    MutableBooleanSet of(boolean... items);

    MutableBooleanSet with(boolean... items);

    /**
     * Same as {@link #withAll(BooleanIterable)}.
     */
    MutableBooleanSet ofAll(BooleanIterable items);

    MutableBooleanSet withAll(BooleanIterable items);
}
