/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.list.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.list.MutableList;

/**
 * This file was automatically generated from template file mutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface MutableCharList extends MutableCharCollection, CharList
{
    void addAtIndex(int index, char element);

    boolean addAllAtIndex(int index, char... source);

    boolean addAllAtIndex(int index, CharIterable source);

    char removeAtIndex(int index);

    char set(int index, char element);

    MutableCharList select(CharPredicate predicate);

    MutableCharList reject(CharPredicate predicate);

    MutableCharList with(char element);

    MutableCharList without(char element);

    MutableCharList withAll(CharIterable elements);

    MutableCharList withoutAll(CharIterable elements);

    <V> MutableList<V> collect(CharToObjectFunction<? extends V> function);

    MutableCharList reverseThis();

    MutableCharList toReversed();

    /**
     * @since 6.0.
     */
    MutableCharList distinct();

    /**
     * Sorts this list mutating its contents and returns the same mutable list (this).
     */
    MutableCharList sortThis();

    MutableCharList asUnmodifiable();

    MutableCharList asSynchronized();

    /**
     * Returns an immutable copy of this list.
     */
    ImmutableCharList toImmutable();

    MutableCharList subList(int fromIndex, int toIndex);
}
