/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleBooleanPredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableDoubleBooleanMap extends DoubleBooleanMap, MutableBooleanValuesMap
{
    void put(double key, boolean value);

    void putAll(DoubleBooleanMap map);

    void removeKey(double key);

    void remove(double key);

    boolean removeKeyIfAbsent(double key, boolean value);

    boolean getIfAbsentPut(double key, boolean value);

    boolean getIfAbsentPut(double key, BooleanFunction0 function);

    boolean getIfAbsentPutWithKey(double key, DoubleToBooleanFunction function);

    <P> boolean getIfAbsentPutWith(double key, BooleanFunction<? super P> function, P parameter);

    boolean updateValue(double key, boolean initialValueIfAbsent, BooleanToBooleanFunction function);

    MutableDoubleBooleanMap select(DoubleBooleanPredicate predicate);

    MutableDoubleBooleanMap reject(DoubleBooleanPredicate predicate);

    MutableDoubleBooleanMap withKeyValue(double key, boolean value);

    MutableDoubleBooleanMap withoutKey(double key);

    MutableDoubleBooleanMap withoutAllKeys(DoubleIterable keys);

    MutableDoubleBooleanMap asUnmodifiable();

    MutableDoubleBooleanMap asSynchronized();
}
