/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.block.function.primitive.IntToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.predicate.primitive.IntDoublePredicate;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableIntDoubleMap extends IntDoubleMap, MutableDoubleValuesMap
{
    void put(int key, double value);

    void putAll(IntDoubleMap map);

    void removeKey(int key);

    void remove(int key);

    double removeKeyIfAbsent(int key, double value);

    double getIfAbsentPut(int key, double value);

    double getIfAbsentPut(int key, DoubleFunction0 function);

    double getIfAbsentPutWithKey(int key, IntToDoubleFunction function);

    <P> double getIfAbsentPutWith(int key, DoubleFunction<? super P> function, P parameter);

    double updateValue(int key, double initialValueIfAbsent, DoubleToDoubleFunction function);

    MutableIntDoubleMap select(IntDoublePredicate predicate);

    MutableIntDoubleMap reject(IntDoublePredicate predicate);

    MutableIntDoubleMap withKeyValue(int key, double value);

    MutableIntDoubleMap withoutKey(int key);

    MutableIntDoubleMap withoutAllKeys(IntIterable keys);

    MutableIntDoubleMap asUnmodifiable();

    MutableIntDoubleMap asSynchronized();


    double addToValue(int key, double toBeAdded);
}
