/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableShortByteMapFactory;
import com.gs.collections.api.map.primitive.ImmutableShortByteMap;
import com.gs.collections.api.map.primitive.ShortByteMap;

/**
 * ImmutableShortByteMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortByteMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableShortByteMapFactoryImpl implements ImmutableShortByteMapFactory
{
    public ImmutableShortByteMap empty()
    {
        return ImmutableShortByteEmptyMap.INSTANCE;
    }

    public ImmutableShortByteMap of()
    {
        return this.empty();
    }

    public ImmutableShortByteMap with()
    {
        return this.empty();
    }

    public ImmutableShortByteMap of(short key, byte value)
    {
        return this.with(key, value);
    }

    public ImmutableShortByteMap with(short key, byte value)
    {
        return new ImmutableShortByteSingletonMap(key, value);
    }

    public ImmutableShortByteMap ofAll(ShortByteMap map)
    {
        return this.withAll(map);
    }

    public ImmutableShortByteMap withAll(ShortByteMap map)
    {
        if (map instanceof ImmutableShortByteMap)
        {
            return (ImmutableShortByteMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            short key = map.keysView().shortIterator().next();
            return new ImmutableShortByteSingletonMap(key, map.get(key));
        }
        return new ImmutableShortByteHashMap(map);
    }
}
