/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableShortIntMapFactory;
import com.gs.collections.api.map.primitive.ImmutableShortIntMap;
import com.gs.collections.api.map.primitive.ShortIntMap;

/**
 * ImmutableShortIntMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortIntMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableShortIntMapFactoryImpl implements ImmutableShortIntMapFactory
{
    public ImmutableShortIntMap empty()
    {
        return ImmutableShortIntEmptyMap.INSTANCE;
    }

    public ImmutableShortIntMap of()
    {
        return this.empty();
    }

    public ImmutableShortIntMap with()
    {
        return this.empty();
    }

    public ImmutableShortIntMap of(short key, int value)
    {
        return this.with(key, value);
    }

    public ImmutableShortIntMap with(short key, int value)
    {
        return new ImmutableShortIntSingletonMap(key, value);
    }

    public ImmutableShortIntMap ofAll(ShortIntMap map)
    {
        return this.withAll(map);
    }

    public ImmutableShortIntMap withAll(ShortIntMap map)
    {
        if (map instanceof ImmutableShortIntMap)
        {
            return (ImmutableShortIntMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            short key = map.keysView().shortIterator().next();
            return new ImmutableShortIntSingletonMap(key, map.get(key));
        }
        return new ImmutableShortIntHashMap(map);
    }
}
