/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.factory.map.primitive.MutableObjectLongMapFactory;
import com.gs.collections.api.map.primitive.MutableObjectLongMap;
import com.gs.collections.api.map.primitive.ObjectLongMap;

/**
 * MutableObjectLongMapFactoryImpl is a factory implementation which creates instances of type {@link MutableObjectLongMap}.
 * This file was automatically generated from template file mutableObjectPrimitiveMapFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableObjectLongMapFactoryImpl implements MutableObjectLongMapFactory
{
    public <K> MutableObjectLongMap<K> empty()
    {
        return new ObjectLongHashMap(0);
    }

    public <K> MutableObjectLongMap<K> of()
    {
        return this.empty();
    }

    public <K> MutableObjectLongMap<K> with()
    {
        return this.empty();
    }

    public <K> MutableObjectLongMap<K> ofAll(ObjectLongMap<? extends K> map)
    {
        return this.withAll(map);
    }

    public <K> MutableObjectLongMap<K> withAll(ObjectLongMap<? extends K> map)
    {
        if (map.isEmpty())
        {
            return this.empty();
        }
        return new ObjectLongHashMap<K>(map);
    }
}
