/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.FloatToDoubleFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.FloatDoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.MutableDoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.ImmutableFloatDoubleMap;
import com.gs.collections.api.map.primitive.FloatDoubleMap;
import com.gs.collections.api.map.primitive.MutableFloatDoubleMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.tuple.primitive.FloatDoublePair;
import com.gs.collections.impl.factory.primitive.FloatDoubleMaps;
import com.gs.collections.impl.iterator.UnmodifiableDoubleIterator;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableFloatDoubleMap
        implements MutableFloatDoubleMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableFloatDoubleMap map;

    UnmodifiableFloatDoubleMap(MutableFloatDoubleMap map)
    {
        this.map = map;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(float key, double value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(FloatDoubleMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(float key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(float key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public double removeKeyIfAbsent(float key, double value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public double getIfAbsentPut(float key, double value)
    {
        return this.map.getIfAbsentPut(key, new DoubleFunction0()
        {
            public double value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public double getIfAbsentPut(float key, DoubleFunction0 function)
    {
        return this.map.getIfAbsentPut(key, new DoubleFunction0()
        {
            public double value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public double getIfAbsentPutWithKey(float key, FloatToDoubleFunction function)
    {
        return this.map.getIfAbsentPut(key, new DoubleFunction0()
        {
            public double value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public <P> double getIfAbsentPutWith(float key, DoubleFunction<? super P> function, P parameter)
    {
        return this.map.getIfAbsentPut(key, new DoubleFunction0()
        {
            public double value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public double updateValue(float key, double initialValueIfAbsent, DoubleToDoubleFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public double get(float key)
    {
        return this.map.get(key);
    }

    public double getIfAbsent(float key, double ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public double getOrThrow(float key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(float key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(double value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(DoubleProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatDoubleProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyFloatIterable keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<FloatDoublePair> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    public MutableFloatDoubleMap select(FloatDoublePredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableFloatDoubleMap reject(FloatDoublePredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public MutableDoubleIterator doubleIterator()
    {
        return new UnmodifiableDoubleIterator(this.map.doubleIterator());
    }

    public void forEach(DoubleProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(DoublePredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(DoublePredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableDoubleCollection select(DoublePredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableDoubleCollection reject(DoublePredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public double sum()
    {
        return this.map.sum();
    }

    public double max()
    {
        return this.map.max();
    }

    public double maxIfEmpty(double defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public double min()
    {
        return this.map.min();
    }

    public double minIfEmpty(double defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public double addToValue(float key, double toBeAdded)
    {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public double[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableDoubleList toSortedList()
    {
        return this.map.toSortedList();
    }

    public double[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(double value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(double... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(DoubleIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableDoubleList toList()
    {
        return this.map.toList();
    }

    public MutableDoubleSet toSet()
    {
        return this.map.toSet();
    }

    public MutableDoubleBag toBag()
    {
        return this.map.toBag();
    }

    public LazyDoubleIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableFloatDoubleMap withKeyValue(float key, double value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableFloatDoubleMap withoutKey(float key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableFloatDoubleMap withoutAllKeys(FloatIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableFloatDoubleMap asUnmodifiable()
    {
        return this;
    }

    public MutableFloatDoubleMap asSynchronized()
    {
        return new SynchronizedFloatDoubleMap(this);
    }

    public ImmutableFloatDoubleMap toImmutable()
    {
        return FloatDoubleMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableFloatSet keySet()
    {
        return UnmodifiableFloatSet.of(this.map.keySet());
    }

    public MutableDoubleCollection values()
    {
        return UnmodifiableDoubleCollection.of(this.map.values());
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
