/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.factory.set.primitive.MutableByteSetFactory;
import com.gs.collections.api.set.primitive.MutableByteSet;

/**
 * MutableByteSetFactoryImpl is a factory implementation which creates instances of type {@link MutableByteSet}.
 * This file was automatically generated from template file mutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableByteSetFactoryImpl implements MutableByteSetFactory
{
    public MutableByteSet empty()
    {
        return new ByteHashSet();
    }

    public MutableByteSet of()
    {
        return this.empty();
    }

    public MutableByteSet with()
    {
        return this.empty();
    }

    public MutableByteSet of(byte... items)
    {
        return this.with(items);
    }

    public MutableByteSet with(byte... items)
    {
        if (items == null || items.length == 0)
        {
            return this.empty();
        }
        return ByteHashSet.newSetWith(items);
    }

    public MutableByteSet ofAll(ByteIterable items)
    {
        return this.withAll(items);
    }

    public MutableByteSet withAll(ByteIterable items)
    {
        return ByteHashSet.newSet(items);
    }
}
