/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.utility.internal.primitive;

import java.io.IOException;
import java.util.Collection;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.LongIterator;

/**
 * This file was automatically generated from template file primitiveIterableIterate.stg.
 *
 * @since 5.0
 */
public final class LongIterableIterate
{
    private LongIterableIterate()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }

    public static boolean isEmpty(LongIterable iterable)
    {
        return !iterable.longIterator().hasNext();
    }

    public static boolean notEmpty(LongIterable iterable)
    {
        return !LongIterableIterate.isEmpty(iterable);
    }

    public static void forEach(LongIterable iterable, LongProcedure procedure)
    {
        LongIteratorIterate.forEach(iterable.longIterator(), procedure);
    }

    public static <R extends MutableLongCollection> R select(LongIterable iterable, LongPredicate predicate, R targetCollection)
    {
        return LongIteratorIterate.select(iterable.longIterator(), predicate, targetCollection);
    }

    public static <R extends MutableLongCollection> R reject(LongIterable iterable, LongPredicate predicate, R targetCollection)
    {
        return LongIteratorIterate.reject(iterable.longIterator(), predicate, targetCollection);
    }

    public static <V, R extends Collection<V>> R collect(
            LongIterable iterable,
            LongToObjectFunction<? extends V> function,
            R targetCollection)
    {
        return LongIteratorIterate.collect(iterable.longIterator(), function, targetCollection);
    }

    public static long detectIfNone(LongIterable iterable, LongPredicate predicate, long ifNone)
    {
        return LongIteratorIterate.detectIfNone(iterable.longIterator(), predicate, ifNone);
    }

    public static int count(LongIterable iterable, LongPredicate predicate)
    {
        return LongIteratorIterate.count(iterable.longIterator(), predicate);
    }

    public static boolean anySatisfy(LongIterable iterable, LongPredicate predicate)
    {
        return LongIteratorIterate.anySatisfy(iterable.longIterator(), predicate);
    }

    public static boolean allSatisfy(LongIterable iterable, LongPredicate predicate)
    {
        return LongIteratorIterate.allSatisfy(iterable.longIterator(), predicate);
    }

    public static boolean noneSatisfy(LongIterable iterable, LongPredicate predicate)
    {
        return LongIteratorIterate.noneSatisfy(iterable.longIterator(), predicate);
    }

    public static long sum(LongIterable iterable)
    {
        return LongIteratorIterate.sum(iterable.longIterator());
    }

    public static long max(LongIterable iterable)
    {
        return LongIteratorIterate.max(iterable.longIterator());
    }

    public static long maxIfEmpty(LongIterable iterable, long ifEmpty)
    {
        if (LongIterableIterate.isEmpty(iterable))
        {
            return ifEmpty;
        }
        return LongIteratorIterate.max(iterable.longIterator());
    }

    public static long min(LongIterable iterable)
    {
        return LongIteratorIterate.min(iterable.longIterator());
    }

    public static long minIfEmpty(LongIterable iterable, long ifEmpty)
    {
        if (LongIterableIterate.isEmpty(iterable))
        {
            return ifEmpty;
        }
        return LongIteratorIterate.min(iterable.longIterator());
    }

    public static void appendString(
            LongIterable iterable,
            Appendable appendable,
            String start,
            String separator,
            String end)
    {
        try
        {
            appendable.append(start);

            LongIterator iterator = iterable.longIterator();
            if (iterator.hasNext())
            {
                appendable.append(stringValueOfItem(iterable, iterator.next()));
                while (iterator.hasNext())
                {
                    appendable.append(separator);
                    appendable.append(stringValueOfItem(iterable, iterator.next()));
                }
            }

            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public static <T> T injectInto(LongIterable iterable, T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return LongIteratorIterate.injectInto(iterable.longIterator(), injectedValue, function);
    }

    private static <T> String stringValueOfItem(LongIterable iterable, T item)
    {
        return item == iterable
                ? "(this " + iterable.getClass().getSimpleName() + ')'
                : String.valueOf(item);
    }
}
