/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.factory.list.primitive.ImmutableDoubleListFactory;
import com.gs.collections.api.list.primitive.ImmutableDoubleList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableDoubleArrayList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableDoubleEmptyList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableDoubleSingletonList;

public class ImmutableDoubleListFactoryImpl
implements ImmutableDoubleListFactory {
    public ImmutableDoubleList empty() {
        return ImmutableDoubleEmptyList.INSTANCE;
    }

    public ImmutableDoubleList of() {
        return this.empty();
    }

    public ImmutableDoubleList with() {
        return this.empty();
    }

    public ImmutableDoubleList of(double one) {
        return this.with(one);
    }

    public ImmutableDoubleList with(double one) {
        return new ImmutableDoubleSingletonList(one);
    }

    public ImmutableDoubleList of(double ... items) {
        return this.with(items);
    }

    public ImmutableDoubleList with(double ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableDoubleArrayList.newListWith(items);
    }

    public ImmutableDoubleList ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    public ImmutableDoubleList withAll(DoubleIterable items) {
        if (items instanceof ImmutableDoubleList) {
            return (ImmutableDoubleList)items;
        }
        return this.with(items.toArray());
    }
}

