/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.mutable.primitive;

import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ObjectShortIntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortIntProcedure;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.ImmutableShortList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.list.primitive.ShortList;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedShortCollection;
import com.gs.collections.impl.factory.primitive.ShortLists;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseShortIterable;
import com.gs.collections.impl.list.mutable.primitive.UnmodifiableShortList;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedShortList
extends AbstractSynchronizedShortCollection
implements MutableShortList {
    private static final long serialVersionUID = 1L;

    SynchronizedShortList(MutableShortList list) {
        super((MutableShortCollection)list);
    }

    SynchronizedShortList(MutableShortList list, Object newLock) {
        super((MutableShortCollection)list, newLock);
    }

    @GuardedBy(value="getLock()")
    private MutableShortList getMutableShortList() {
        return (MutableShortList)this.getShortCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short get(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortList().get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getFirst() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortList().getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getLast() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortList().getLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(short value) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortList().indexOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(short value) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortList().lastIndexOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAtIndex(int index, short element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortList().addAtIndex(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAllAtIndex(int index, short ... source) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortList().addAllAtIndex(index, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAllAtIndex(int index, ShortIterable source) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortList().addAllAtIndex(index, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short removeAtIndex(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortList().removeAtIndex(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short set(int index, short element) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortList().set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedShortList with(short element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortList().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedShortList without(short element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortList().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedShortList withAll(ShortIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortList().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedShortList withoutAll(ShortIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortList().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableShortList select(ShortPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortList().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableShortList reject(ShortPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortList().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableList<V> collect(ShortToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortList().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableShortList sortThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortList().sortThis();
        }
        return this;
    }

    public long dotProduct(ShortList list) {
        return this.getMutableShortList().dotProduct(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherList) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortList().equals(otherList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortList().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyShortIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyShortIterableAdapter((ShortIterable)this);
        }
    }

    public MutableShortList asUnmodifiable() {
        return new UnmodifiableShortList(this);
    }

    public MutableShortList asSynchronized() {
        return this;
    }

    public ImmutableShortList toImmutable() {
        int size = this.size();
        if (size == 0) {
            return ShortLists.immutable.with();
        }
        if (size == 1) {
            return ShortLists.immutable.with(this.getFirst());
        }
        return ShortLists.immutable.with(this.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableShortList reverseThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortList().reverseThis();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableShortList toReversed() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortList().toReversed();
        }
    }

    public LazyShortIterable asReversed() {
        return ReverseShortIterable.adapt((ShortList)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithIndex(ShortIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortList().forEachWithIndex(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T injectIntoWithIndex(T injectedValue, ObjectShortIntToObjectFunction<? super T, ? extends T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getMutableShortList().injectIntoWithIndex(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableShortList distinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortList().distinct();
        }
    }

    public MutableShortList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}

