/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.factory.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableObjectIntMapFactory;
import com.gs.collections.api.factory.map.primitive.MutableObjectIntMapFactory;
import com.gs.collections.impl.map.immutable.primitive.ImmutableObjectIntMapFactoryImpl;
import com.gs.collections.impl.map.mutable.primitive.MutableObjectIntMapFactoryImpl;

/**
 * IntObjectMaps is a static utility for creating {@link ImmutableObjectIntMapFactory}.
 * This file was automatically generated from template file objectPrimitiveMaps.stg.
 *
 * @since 4.0.
 */
@SuppressWarnings("ConstantNamingConvention")
public final class ObjectIntMaps
{
    public static final ImmutableObjectIntMapFactory immutable = new ImmutableObjectIntMapFactoryImpl();
    public static final MutableObjectIntMapFactory mutable = new MutableObjectIntMapFactoryImpl();

    private ObjectIntMaps()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }
}
