/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleBytePredicate;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleByteProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.DoubleByteMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleByteMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.tuple.primitive.DoubleBytePair;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.ByteLists;
import com.gs.collections.impl.iterator.ImmutableEmptyByteIterator;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import com.gs.collections.impl.utility.LazyIterate;
import com.gs.collections.impl.utility.primitive.LazyDoubleIterate;

/**
 * ImmutableDoubleByteEmptyMap is an optimization for {@link ImmutableDoubleByteMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableDoubleByteEmptyMap implements ImmutableDoubleByteMap, Serializable
{
    static final ImmutableDoubleByteMap INSTANCE = new ImmutableDoubleByteEmptyMap();

    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_VALUE = (byte) 0;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public byte get(double key)
    {
        return EMPTY_VALUE;
    }

    public byte getIfAbsent(double key, byte ifAbsent)
    {
        return ifAbsent;
    }

    public byte getOrThrow(double key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(double key)
    {
        return false;
    }

    public boolean containsValue(byte value)
    {
        return false;
    }

    public void forEachValue(ByteProcedure procedure)
    {
    }

    public void forEachKey(DoubleProcedure procedure)
    {
    }

    public void forEachKeyValue(DoubleByteProcedure procedure)
    {
    }

    public LazyDoubleIterable keysView()
    {
        return LazyDoubleIterate.empty();
    }

    public RichIterable<DoubleBytePair> keyValuesView()
    {
        return LazyIterate.empty();
    }

    public ImmutableDoubleByteMap select(DoubleBytePredicate predicate)
    {
        return this;
    }

    public ImmutableDoubleByteMap reject(DoubleBytePredicate predicate)
    {
        return this;
    }

    public ImmutableDoubleByteMap toImmutable()
    {
        return this;
    }

    public ByteIterator byteIterator()
    {
        return ImmutableEmptyByteIterator.INSTANCE;
    }

    public void forEach(ByteProcedure procedure)
    {
    }

    public int count(BytePredicate predicate)
    {
        return 0;
    }

    public long sum()
    {
        return 0L;
    }

    public byte min()
    {
        throw new NoSuchElementException();
    }

    public byte max()
    {
        throw new NoSuchElementException();
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return defaultValue;
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public byte[] toSortedArray()
    {
        return new byte[0];
    }

    public MutableByteList toSortedList()
    {
        return new ByteArrayList();
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return true;
    }

    public ImmutableByteCollection select(BytePredicate predicate)
    {
        return ByteLists.immutable.with();
    }

    public ImmutableByteCollection reject(BytePredicate predicate)
    {
        return ByteLists.immutable.with();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public byte[] toArray()
    {
        return new byte[0];
    }

    public boolean contains(byte value)
    {
        return false;
    }

    public boolean containsAll(byte... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(ByteIterable source)
    {
        return source.isEmpty();
    }

    public MutableByteList toList()
    {
        return new ByteArrayList();
    }

    public MutableByteSet toSet()
    {
        return new ByteHashSet();
    }

    public MutableByteBag toBag()
    {
        return new ByteHashBag();
    }

    public LazyByteIterable asLazy()
    {
        return new LazyByteIterableAdapter(this);
    }

    public ImmutableDoubleByteMap newWithKeyValue(double key, byte value)
    {
        return new ImmutableDoubleByteSingletonMap(key, value);
    }

    public ImmutableDoubleByteMap newWithoutKey(double key)
    {
        return this;
    }

    public ImmutableDoubleByteMap newWithoutAllKeys(DoubleIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableDoubleSet keySet()
    {
        return UnmodifiableDoubleSet.of(new DoubleHashSet());
    }

    public MutableByteCollection values()
    {
        return UnmodifiableByteCollection.of(new ByteArrayList());
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof DoubleByteMap))
        {
            return false;
        }
        DoubleByteMap map = (DoubleByteMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
