/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.LongToByteFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.LongBytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.LongByteProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.MutableByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.ImmutableLongByteMap;
import com.gs.collections.api.map.primitive.LongByteMap;
import com.gs.collections.api.map.primitive.MutableLongByteMap;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.tuple.primitive.LongBytePair;
import com.gs.collections.impl.factory.primitive.LongByteMaps;
import com.gs.collections.impl.iterator.UnmodifiableByteIterator;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableLongByteMap
        implements MutableLongByteMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableLongByteMap map;

    UnmodifiableLongByteMap(MutableLongByteMap map)
    {
        this.map = map;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(long key, byte value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(LongByteMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(long key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(long key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public byte removeKeyIfAbsent(long key, byte value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public byte getIfAbsentPut(long key, byte value)
    {
        return this.map.getIfAbsentPut(key, new ByteFunction0()
        {
            public byte value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public byte getIfAbsentPut(long key, ByteFunction0 function)
    {
        return this.map.getIfAbsentPut(key, new ByteFunction0()
        {
            public byte value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public byte getIfAbsentPutWithKey(long key, LongToByteFunction function)
    {
        return this.map.getIfAbsentPut(key, new ByteFunction0()
        {
            public byte value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public <P> byte getIfAbsentPutWith(long key, ByteFunction<? super P> function, P parameter)
    {
        return this.map.getIfAbsentPut(key, new ByteFunction0()
        {
            public byte value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public byte updateValue(long key, byte initialValueIfAbsent, ByteToByteFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public byte get(long key)
    {
        return this.map.get(key);
    }

    public byte getIfAbsent(long key, byte ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public byte getOrThrow(long key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(long key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(byte value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(ByteProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(LongProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(LongByteProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyLongIterable keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<LongBytePair> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    public MutableLongByteMap select(LongBytePredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableLongByteMap reject(LongBytePredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public MutableByteIterator byteIterator()
    {
        return new UnmodifiableByteIterator(this.map.byteIterator());
    }

    public void forEach(ByteProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(BytePredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableByteCollection select(BytePredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableByteCollection reject(BytePredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public long sum()
    {
        return this.map.sum();
    }

    public byte max()
    {
        return this.map.max();
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public byte min()
    {
        return this.map.min();
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public byte addToValue(long key, byte toBeAdded)
    {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public byte[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableByteList toSortedList()
    {
        return this.map.toSortedList();
    }

    public byte[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(byte value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(byte... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(ByteIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableByteList toList()
    {
        return this.map.toList();
    }

    public MutableByteSet toSet()
    {
        return this.map.toSet();
    }

    public MutableByteBag toBag()
    {
        return this.map.toBag();
    }

    public LazyByteIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableLongByteMap withKeyValue(long key, byte value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableLongByteMap withoutKey(long key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableLongByteMap withoutAllKeys(LongIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableLongByteMap asUnmodifiable()
    {
        return this;
    }

    public MutableLongByteMap asSynchronized()
    {
        return new SynchronizedLongByteMap(this);
    }

    public ImmutableLongByteMap toImmutable()
    {
        return LongByteMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableLongSet keySet()
    {
        return UnmodifiableLongSet.of(this.map.keySet());
    }

    public MutableByteCollection values()
    {
        return UnmodifiableByteCollection.of(this.map.values());
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
