/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.set.primitive.ImmutableShortSet;
import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.set.primitive.AbstractShortSet;

/**
 * This file was automatically generated from template file abstractImmutablePrimitiveSet.stg.
 *
 * @since 6.0.
 */
public abstract class AbstractImmutableShortSet extends AbstractShortSet implements ImmutableShortSet
{
    public ImmutableShortSet newWith(short element)
    {
        return ShortHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableShortSet newWithout(short element)
    {
        return ShortHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableShortSet newWithAll(ShortIterable elements)
    {
        return ShortHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableShortSet newWithoutAll(ShortIterable elements)
    {
        return ShortHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public ShortSet freeze()
    {
        return this;
    }

    public ImmutableShortSet toImmutable()
    {
        return this;
    }
}
