/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.factory.set.primitive.ImmutableIntSetFactory;
import com.gs.collections.api.set.primitive.ImmutableIntSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;

/**
 * ImmutableIntSetFactoryImpl is a factory implementation which creates instances of type {@link ImmutableIntSet}.
 * This file was automatically generated from template file immutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableIntSetFactoryImpl implements ImmutableIntSetFactory
{
    public ImmutableIntSet empty()
    {
        return ImmutableIntEmptySet.INSTANCE;
    }

    public ImmutableIntSet of()
    {
        return this.empty();
    }

    public ImmutableIntSet with()
    {
        return this.empty();
    }

    public ImmutableIntSet of(int one)
    {
        return this.with(one);
    }

    public ImmutableIntSet with(int one)
    {
        return new ImmutableIntSingletonSet(one);
    }

    public ImmutableIntSet of(int... items)
    {
        return this.with(items);
    }

    public ImmutableIntSet with(int... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return IntHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableIntSet ofAll(IntIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableIntSet withAll(IntIterable items)
    {
        if (items instanceof ImmutableIntSet)
        {
            return (ImmutableIntSet) items;
        }
        return this.with(items.toArray());
    }
}
