/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.mutable;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.ParallelListIterable;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.multimap.list.MutableListMultimap;
import com.gs.collections.api.ordered.OrderedIterable;
import com.gs.collections.api.partition.list.PartitionMutableList;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.collection.mutable.AbstractUnmodifiableMutableCollection;
import com.gs.collections.impl.collection.mutable.UnmodifiableCollectionSerializationProxy;
import com.gs.collections.impl.lazy.ReverseIterable;
import com.gs.collections.impl.list.mutable.ListAdapter;
import com.gs.collections.impl.list.mutable.RandomAccessListAdapter;
import com.gs.collections.impl.list.mutable.SynchronizedMutableList;
import com.gs.collections.impl.list.mutable.UnmodifiableListIteratorAdapter;
import com.gs.collections.impl.stack.mutable.ArrayStack;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.concurrent.ExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmodifiableMutableList<T>
extends AbstractUnmodifiableMutableCollection<T>
implements MutableList<T>,
Serializable {
    UnmodifiableMutableList(MutableList<? extends T> mutableList) {
        super(mutableList);
    }

    public static <E, L extends List<E>> UnmodifiableMutableList<E> of(L list) {
        if (list == null) {
            throw new IllegalArgumentException("cannot create an UnmodifiableMutableList for null");
        }
        if (list instanceof RandomAccess) {
            return new RandomAccessUnmodifiableMutableList(RandomAccessListAdapter.adapt(list));
        }
        return new UnmodifiableMutableList(ListAdapter.adapt(list));
    }

    private MutableList<T> getMutableList() {
        return (MutableList)this.getMutableCollection();
    }

    public boolean equals(Object obj) {
        return this.getMutableList().equals(obj);
    }

    public int hashCode() {
        return this.getMutableList().hashCode();
    }

    @Override
    public MutableList<T> asUnmodifiable() {
        return this;
    }

    @Override
    public ImmutableList<T> toImmutable() {
        return this.getMutableList().toImmutable();
    }

    @Override
    public MutableList<T> asSynchronized() {
        return SynchronizedMutableList.of(this);
    }

    public UnmodifiableMutableList<T> clone() {
        return this;
    }

    @Override
    public MutableList<T> newEmpty() {
        return this.getMutableList().newEmpty();
    }

    @Override
    public MutableList<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super T, ? super S> predicate) {
        return this.getMutableList().corresponds(other, predicate);
    }

    public void forEach(int fromIndex, int toIndex, Procedure<? super T> procedure) {
        this.getMutableList().forEach(fromIndex, toIndex, procedure);
    }

    public void reverseForEach(Procedure<? super T> procedure) {
        this.getMutableList().reverseForEach(procedure);
    }

    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super T> objectIntProcedure) {
        this.getMutableList().forEachWithIndex(fromIndex, toIndex, objectIntProcedure);
    }

    public UnmodifiableMutableList<T> sortThis(Comparator<? super T> comparator) {
        throw new UnsupportedOperationException("Cannot call sortThis() on " + this.getClass().getSimpleName());
    }

    public UnmodifiableMutableList<T> sortThis() {
        throw new UnsupportedOperationException("Cannot call sortThis() on " + this.getClass().getSimpleName());
    }

    public MutableList<T> toReversed() {
        return this.getMutableList().toReversed();
    }

    public MutableList<T> reverseThis() {
        throw new UnsupportedOperationException("Cannot call reverseThis() on " + this.getClass().getSimpleName());
    }

    public MutableStack<T> toStack() {
        return ArrayStack.newStack(this.getMutableList());
    }

    public <V extends Comparable<? super V>> MutableList<T> sortThisBy(Function<? super T, ? extends V> function) {
        throw new UnsupportedOperationException("Cannot call sortThisBy() on " + this.getClass().getSimpleName());
    }

    public MutableList<T> sortThisByInt(IntFunction<? super T> function) {
        throw new UnsupportedOperationException("Cannot call sortThisByInt() on " + this.getClass().getSimpleName());
    }

    public MutableList<T> sortThisByBoolean(BooleanFunction<? super T> function) {
        throw new UnsupportedOperationException("Cannot call sortThisByBoolean() on " + this.getClass().getSimpleName());
    }

    public MutableList<T> sortThisByChar(CharFunction<? super T> function) {
        throw new UnsupportedOperationException("Cannot call sortThisByChar() on " + this.getClass().getSimpleName());
    }

    public MutableList<T> sortThisByByte(ByteFunction<? super T> function) {
        throw new UnsupportedOperationException("Cannot call sortThisByByte() on " + this.getClass().getSimpleName());
    }

    public MutableList<T> sortThisByShort(ShortFunction<? super T> function) {
        throw new UnsupportedOperationException("Cannot call sortThisByShort() on " + this.getClass().getSimpleName());
    }

    public MutableList<T> sortThisByFloat(FloatFunction<? super T> function) {
        throw new UnsupportedOperationException("Cannot call sortThisByFloat() on " + this.getClass().getSimpleName());
    }

    public MutableList<T> sortThisByLong(LongFunction<? super T> function) {
        throw new UnsupportedOperationException("Cannot call sortThisByLong() on " + this.getClass().getSimpleName());
    }

    public MutableList<T> sortThisByDouble(DoubleFunction<? super T> function) {
        throw new UnsupportedOperationException("Cannot call sortThisByDouble() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(int index, Collection<? extends T> collection) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public T get(int index) {
        return (T)this.getMutableList().get(index);
    }

    public T set(int index, T element) {
        throw new UnsupportedOperationException("Cannot call set() on " + this.getClass().getSimpleName());
    }

    public void add(int index, T element) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    public T remove(int index) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public int indexOf(Object o) {
        return this.getMutableList().indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.getMutableList().lastIndexOf(o);
    }

    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    public ListIterator<T> listIterator(int index) {
        return new UnmodifiableListIteratorAdapter(this.getMutableList().listIterator(index));
    }

    public UnmodifiableMutableList<T> subList(int fromIndex, int toIndex) {
        MutableList subList = this.getMutableList().subList(fromIndex, toIndex);
        return UnmodifiableMutableList.of(subList);
    }

    @Override
    public <P, A> MutableList<A> collectWith(Function2<? super T, ? super P, ? extends A> function, P parameter) {
        return this.getMutableList().collectWith(function, parameter);
    }

    @Override
    public <V> MutableList<V> collect(Function<? super T, ? extends V> function) {
        return this.getMutableList().collect(function);
    }

    public MutableBooleanList collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return this.getMutableList().collectBoolean(booleanFunction);
    }

    public MutableByteList collectByte(ByteFunction<? super T> byteFunction) {
        return this.getMutableList().collectByte(byteFunction);
    }

    public MutableCharList collectChar(CharFunction<? super T> charFunction) {
        return this.getMutableList().collectChar(charFunction);
    }

    public MutableDoubleList collectDouble(DoubleFunction<? super T> doubleFunction) {
        return this.getMutableList().collectDouble(doubleFunction);
    }

    public MutableFloatList collectFloat(FloatFunction<? super T> floatFunction) {
        return this.getMutableList().collectFloat(floatFunction);
    }

    public MutableIntList collectInt(IntFunction<? super T> intFunction) {
        return this.getMutableList().collectInt(intFunction);
    }

    public MutableLongList collectLong(LongFunction<? super T> longFunction) {
        return this.getMutableList().collectLong(longFunction);
    }

    public MutableShortList collectShort(ShortFunction<? super T> shortFunction) {
        return this.getMutableList().collectShort(shortFunction);
    }

    @Override
    public <V> MutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.getMutableList().flatCollect(function);
    }

    @Override
    public <V> MutableList<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.getMutableList().collectIf(predicate, function);
    }

    public int detectIndex(Predicate<? super T> predicate) {
        return this.getMutableList().detectIndex(predicate);
    }

    public int detectLastIndex(Predicate<? super T> predicate) {
        return this.getMutableList().detectLastIndex(predicate);
    }

    @Override
    public <V> MutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.getMutableList().groupBy(function);
    }

    @Override
    public <V> MutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.getMutableList().groupByEach(function);
    }

    @Override
    public MutableList<T> reject(Predicate<? super T> predicate) {
        return this.getMutableList().reject(predicate);
    }

    @Override
    public <P> MutableList<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.getMutableList().rejectWith(predicate, parameter);
    }

    @Override
    public MutableList<T> select(Predicate<? super T> predicate) {
        return this.getMutableList().select(predicate);
    }

    @Override
    public <P> MutableList<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.getMutableList().selectWith(predicate, parameter);
    }

    @Override
    public PartitionMutableList<T> partition(Predicate<? super T> predicate) {
        return this.getMutableList().partition(predicate);
    }

    @Override
    public <P> PartitionMutableList<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.getMutableList().partitionWith(predicate, parameter);
    }

    @Override
    public <S> MutableList<S> selectInstancesOf(Class<S> clazz) {
        return this.getMutableList().selectInstancesOf(clazz);
    }

    public MutableList<T> distinct() {
        return this.getMutableList().distinct();
    }

    @Override
    public <S> MutableList<Pair<T, S>> zip(Iterable<S> that) {
        return this.getMutableList().zip(that);
    }

    @Override
    public MutableList<Pair<T, Integer>> zipWithIndex() {
        return this.getMutableList().zipWithIndex();
    }

    public MutableList<T> take(int count) {
        return this.getMutableList().take(count);
    }

    public MutableList<T> takeWhile(Predicate<? super T> predicate) {
        return this.getMutableList().takeWhile(predicate);
    }

    public MutableList<T> drop(int count) {
        return this.getMutableList().drop(count);
    }

    public MutableList<T> dropWhile(Predicate<? super T> predicate) {
        return this.getMutableList().dropWhile(predicate);
    }

    public PartitionMutableList<T> partitionWhile(Predicate<? super T> predicate) {
        return this.getMutableList().partitionWhile(predicate);
    }

    public LazyIterable<T> asReversed() {
        return ReverseIterable.adapt(this);
    }

    public ParallelListIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        return this.getMutableList().asParallel(executorService, batchSize);
    }

    public int binarySearch(T key, Comparator<? super T> comparator) {
        return Collections.binarySearch(this, key, comparator);
    }

    public int binarySearch(T key) {
        return Collections.binarySearch(this, key);
    }

    @Override
    public MutableList<T> with(T element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableList<T> without(T element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableList<T> withAll(Iterable<? extends T> elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableList<T> withoutAll(Iterable<? extends T> elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    protected Object writeReplace() {
        return new UnmodifiableCollectionSerializationProxy<T>(this.getMutableList());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RandomAccessUnmodifiableMutableList<T>
    extends UnmodifiableMutableList<T>
    implements RandomAccess {
        private static final long serialVersionUID = 1L;

        RandomAccessUnmodifiableMutableList(MutableList<? extends T> mutableList) {
            super(mutableList);
        }

        @Override
        public RandomAccessUnmodifiableMutableList<T> clone() {
            return this;
        }
    }
}

