/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortFloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.ImmutableShortFloatMap;
import com.gs.collections.api.map.primitive.ShortFloatMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.tuple.primitive.ShortFloatPair;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.ShortFloatMaps;
import com.gs.collections.impl.factory.primitive.ShortLists;
import com.gs.collections.impl.iterator.UnmodifiableFloatIterator;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.map.mutable.primitive.ShortFloatHashMap;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableShortFloatSingletonMap
implements ImmutableShortFloatMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_VALUE = 0.0f;
    private final short key1;
    private final float value1;

    ImmutableShortFloatSingletonMap(short key1, float value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public float get(short key) {
        return this.getIfAbsent(key, 0.0f);
    }

    public float getIfAbsent(short key, float ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public float getOrThrow(short key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(short key) {
        return this.key1 == key;
    }

    public boolean containsValue(float value) {
        return Float.compare(this.value1, value) == 0;
    }

    public void forEachValue(FloatProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(ShortProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ShortFloatProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyShortIterable keysView() {
        return ShortLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ShortFloatPair> keyValuesView() {
        return Lists.immutable.of((Object)PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableShortFloatMap select(ShortFloatPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? ShortFloatHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new ShortFloatHashMap().toImmutable();
    }

    public ImmutableShortFloatMap reject(ShortFloatPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new ShortFloatHashMap().toImmutable() : ShortFloatHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public ImmutableShortFloatMap toImmutable() {
        return this;
    }

    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator((FloatIterator)ShortFloatHashMap.newWithKeysValues(this.key1, this.value1).floatIterator());
    }

    public void forEach(FloatProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(FloatPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public double sum() {
        return this.value1;
    }

    public float min() {
        return this.value1;
    }

    public float max() {
        return this.value1;
    }

    public float maxIfEmpty(float defaultValue) {
        return this.value1;
    }

    public float minIfEmpty(float defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public float[] toSortedArray() {
        return new float[]{this.value1};
    }

    public MutableFloatList toSortedList() {
        return FloatArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableFloatCollection select(FloatPredicate predicate) {
        return predicate.accept(this.value1) ? FloatArrayList.newListWith(this.value1).toImmutable() : new FloatArrayList().toImmutable();
    }

    public ImmutableFloatCollection reject(FloatPredicate predicate) {
        return predicate.accept(this.value1) ? new FloatArrayList().toImmutable() : FloatArrayList.newListWith(this.value1).toImmutable();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public float[] toArray() {
        return new float[]{this.value1};
    }

    public boolean contains(float value) {
        return Float.compare(this.value1, value) == 0;
    }

    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (Float.compare(this.value1, value) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (Float.compare(this.value1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public MutableFloatList toList() {
        return FloatArrayList.newListWith(this.value1);
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSetWith(this.value1);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBagWith(this.value1);
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public ImmutableShortFloatMap newWithKeyValue(short key, float value) {
        return ShortFloatMaps.immutable.withAll((ShortFloatMap)ShortFloatHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableShortFloatMap newWithoutKey(short key) {
        return this.key1 == key ? ShortFloatMaps.immutable.with() : this;
    }

    public ImmutableShortFloatMap newWithoutAllKeys(ShortIterable keys) {
        return keys.contains(this.key1) ? ShortFloatMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableShortSet keySet() {
        return UnmodifiableShortSet.of(ShortHashSet.newSetWith(this.key1));
    }

    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of((MutableFloatCollection)FloatArrayList.newListWith(this.value1));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShortFloatMap)) {
            return false;
        }
        ShortFloatMap map = (ShortFloatMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && Float.compare(this.value1, map.getOrThrow(this.key1)) == 0;
    }

    public int hashCode() {
        return this.key1 ^ Float.floatToIntBits(this.value1);
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

