/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.function.primitive.IntToByteFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntBytePredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.IntByteProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.iterator.MutableByteIterator;
import com.gs.collections.api.iterator.MutableIntIterator;
import com.gs.collections.api.map.primitive.ImmutableIntByteMap;
import com.gs.collections.api.map.primitive.IntByteMap;
import com.gs.collections.api.map.primitive.MutableIntByteMap;
import com.gs.collections.api.set.primitive.ByteSet;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.tuple.primitive.IntBytePair;
import com.gs.collections.impl.SpreadFunctions;
import com.gs.collections.impl.factory.primitive.IntByteMaps;
import com.gs.collections.impl.iterator.UnmodifiableIntIterator;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.AbstractLazyIntIterable;
import com.gs.collections.impl.map.mutable.primitive.AbstractMutableByteValuesMap;
import com.gs.collections.impl.map.mutable.primitive.AbstractMutableIntKeySet;
import com.gs.collections.impl.map.mutable.primitive.ImmutableIntMapKeySet;
import com.gs.collections.impl.map.mutable.primitive.MutableIntKeysMap;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedIntByteMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableIntByteMap;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntByteHashMap
extends AbstractMutableByteValuesMap
implements MutableIntByteMap,
Externalizable,
MutableIntKeysMap {
    private static final byte EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_KEY = 0;
    private static final int REMOVED_KEY = 1;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 4;
    private static final int INITIAL_LINEAR_PROBE = 8;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private int[] keys;
    private byte[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableByteValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public IntByteHashMap() {
        this.allocateTable(16);
    }

    public IntByteHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public IntByteHashMap(IntByteMap map) {
        if (map instanceof IntByteHashMap && ((IntByteHashMap)map).occupiedWithSentinels == 0) {
            IntByteHashMap hashMap = (IntByteHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keys = Arrays.copyOf(hashMap.keys, hashMap.keys.length);
            this.values = Arrays.copyOf(hashMap.values, hashMap.values.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static IntByteHashMap newWithKeysValues(int key1, byte value1) {
        return new IntByteHashMap(1).withKeyValue(key1, value1);
    }

    public static IntByteHashMap newWithKeysValues(int key1, byte value1, int key2, byte value2) {
        return new IntByteHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static IntByteHashMap newWithKeysValues(int key1, byte value1, int key2, byte value2, int key3, byte value3) {
        return new IntByteHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static IntByteHashMap newWithKeysValues(int key1, byte value1, int key2, byte value2, int key3, byte value3, int key4, byte value4) {
        return new IntByteHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableByteValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected byte getEmptyValue() {
        return 0;
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected byte getValueAtIndex(int index) {
        return this.values[index];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntByteMap)) {
            return false;
        }
        IntByteMap other = (IntByteMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0) || other.containsKey(1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0) || this.sentinelValues.zeroValue != other.getOrThrow(0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1) || this.sentinelValues.oneValue != other.getOrThrow(1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (!IntByteHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntByteHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ this.values[i];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (!IntByteHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public MutableByteIterator byteIterator() {
        return new InternalByteIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectByteToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntByteHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, (byte)0);
    }

    public void put(int key, byte value) {
        if (IntByteHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        int keyAtIndex = this.keys[index];
        if (keyAtIndex == key) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(byte value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(byte value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    public void putAll(IntByteMap map) {
        map.forEachKeyValue(new IntByteProcedure(){

            public void value(int key, byte value) {
                IntByteHashMap.this.put(key, value);
            }
        });
    }

    @Override
    public void removeKey(int key) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    public void remove(int key) {
        this.removeKey(key);
    }

    public byte removeKeyIfAbsent(int key, byte value) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            byte oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            byte oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            byte oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    public byte getIfAbsentPut(int key, byte value) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public byte getIfAbsentPut(int key, ByteFunction0 function) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.value();
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.value();
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        byte value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> byte getIfAbsentPutWith(int key, ByteFunction<? super P> function, P parameter) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.byteValueOf(parameter);
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value = function.byteValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.byteValueOf(parameter);
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value = function.byteValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        byte value = function.byteValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public byte getIfAbsentPutWithKey(int key, IntToByteFunction function) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        byte value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public byte addToValue(int key, byte toBeAdded) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = (byte)(this.sentinelValues.zeroValue + toBeAdded);
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = (byte)(this.sentinelValues.oneValue + toBeAdded);
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = (byte)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(int key, byte value, int index) {
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1;
        this.values[index] = 0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        int[] copy = new int[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    public byte updateValue(int key, byte initialValueIfAbsent, ByteToByteFunction function) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableByteValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        byte value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public IntByteHashMap withKeyValue(int key1, byte value1) {
        this.put(key1, value1);
        return this;
    }

    public IntByteHashMap withKeysValues(int key1, byte value1, int key2, byte value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public IntByteHashMap withKeysValues(int key1, byte value1, int key2, byte value2, int key3, byte value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public IntByteHashMap withKeysValues(int key1, byte value1, int key2, byte value2, int key3, byte value3, int key4, byte value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public IntByteHashMap withoutKey(int key) {
        this.removeKey(key);
        return this;
    }

    public IntByteHashMap withoutAllKeys(IntIterable keys) {
        keys.forEach(new IntProcedure(){

            public void value(int key) {
                IntByteHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableIntByteMap asUnmodifiable() {
        return new UnmodifiableIntByteMap(this);
    }

    public MutableIntByteMap asSynchronized() {
        return new SynchronizedIntByteMap(this);
    }

    public ImmutableIntByteMap toImmutable() {
        return IntByteMaps.immutable.ofAll((IntByteMap)this);
    }

    public byte get(int key) {
        return this.getIfAbsent(key, (byte)0);
    }

    public byte getIfAbsent(int key, byte ifAbsent) {
        if (IntByteHashMap.isEmptyKey(key) || IntByteHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private byte getForSentinel(int key, byte ifAbsent) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private byte slowGetIfAbsent(int key, byte ifAbsent) {
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    private byte fastGetIfAbsent(int key, byte ifAbsent) {
        int index = this.mask(key);
        for (int i = 0; i < 8; ++i) {
            int keyAtIndex = this.keys[index];
            if (keyAtIndex == key) {
                return this.values[index];
            }
            if (keyAtIndex == 0) {
                return ifAbsent;
            }
            index = index + 1 & this.keys.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private byte slowGetIfAbsentTwo(int key, byte ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public byte getOrThrow(int key) {
        if (IntByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (IntByteHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(int key) {
        if (IntByteHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (IntByteHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(IntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntByteHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    public void forEachKeyValue(IntByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntByteHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyIntIterable keysView() {
        return new KeysView();
    }

    public RichIterable<IntBytePair> keyValuesView() {
        return new KeyValuesView();
    }

    public IntByteHashMap select(IntBytePredicate predicate) {
        IntByteHashMap result = new IntByteHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public IntByteHashMap reject(IntBytePredicate predicate) {
        IntByteHashMap result = new IntByteHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntByteHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeInt(0);
                out.writeByte(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeInt(1);
                out.writeByte(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntByteHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeInt(this.keys[i]);
            out.writeByte(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readInt(), in.readByte());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        int[] old = this.keys;
        byte[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!IntByteHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(int element) {
        int index = this.mask(element);
        int keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        for (int i = 1; i < 8; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(int element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 8; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            int keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(int element, int removedIndex) {
        int nextIndex = SpreadFunctions.intSpreadOne(element);
        int spreadTwo = Integer.reverse(SpreadFunctions.intSpreadTwo(element)) | 1;
        int keyAtIndex;
        while ((keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(int element) {
        int code = SpreadFunctions.intSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(int element) {
        int code = SpreadFunctions.intSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new int[sizeToAllocate];
        this.values = new byte[sizeToAllocate];
    }

    private static boolean isEmptyKey(int key) {
        return key == 0;
    }

    private static boolean isRemovedKey(int key) {
        return key == 1;
    }

    private static boolean isNonSentinel(int key) {
        return !IntByteHashMap.isEmptyKey(key) && !IntByteHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !IntByteHashMap.isEmptyKey(this.keys[index]) && !IntByteHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length >> 2;
    }

    public MutableIntSet keySet() {
        return new KeySet();
    }

    public MutableByteCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ int[] access$302(IntByteHashMap x0, int[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$502(IntByteHashMap x0, byte[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<IntBytePair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super IntBytePair> procedure) {
            if (IntByteHashMap.this.sentinelValues != null) {
                if (((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0, ((IntByteHashMap)IntByteHashMap.this).sentinelValues.zeroValue));
                }
                if (((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1, ((IntByteHashMap)IntByteHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < IntByteHashMap.this.keys.length; ++i) {
                if (!IntByteHashMap.isNonSentinel(IntByteHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(IntByteHashMap.this.keys[i], IntByteHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super IntBytePair> objectIntProcedure) {
            int index = 0;
            if (IntByteHashMap.this.sentinelValues != null) {
                if (((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(0, ((IntByteHashMap)IntByteHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(1, ((IntByteHashMap)IntByteHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < IntByteHashMap.this.keys.length; ++i) {
                if (!IntByteHashMap.isNonSentinel(IntByteHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(IntByteHashMap.this.keys[i], IntByteHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super IntBytePair, ? super P> procedure, P parameter) {
            if (IntByteHashMap.this.sentinelValues != null) {
                if (((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0, ((IntByteHashMap)IntByteHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1, ((IntByteHashMap)IntByteHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < IntByteHashMap.this.keys.length; ++i) {
                if (!IntByteHashMap.isNonSentinel(IntByteHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(IntByteHashMap.this.keys[i], IntByteHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<IntBytePair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<IntBytePair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public IntBytePair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (IntByteHashMap.this.containsKey(0)) {
                        return PrimitiveTuples.pair(0, ((IntByteHashMap)IntByteHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (IntByteHashMap.this.containsKey(1)) {
                        return PrimitiveTuples.pair(1, ((IntByteHashMap)IntByteHashMap.this).sentinelValues.oneValue);
                    }
                }
                int[] keys = IntByteHashMap.this.keys;
                while (!IntByteHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                IntBytePair result = PrimitiveTuples.pair(keys[this.position], IntByteHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != IntByteHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableByteValuesMap.AbstractByteValuesCollection {
        private ValuesCollection() {
        }

        public MutableByteIterator byteIterator() {
            return IntByteHashMap.this.byteIterator();
        }

        public boolean remove(byte item) {
            int oldSize = IntByteHashMap.this.size();
            if (IntByteHashMap.this.sentinelValues != null) {
                if (((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsZeroKey && item == ((IntByteHashMap)IntByteHashMap.this).sentinelValues.zeroValue) {
                    IntByteHashMap.this.removeKey(0);
                }
                if (((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsOneKey && item == ((IntByteHashMap)IntByteHashMap.this).sentinelValues.oneValue) {
                    IntByteHashMap.this.removeKey(1);
                }
            }
            for (int i = 0; i < IntByteHashMap.this.keys.length; ++i) {
                if (!IntByteHashMap.isNonSentinel(IntByteHashMap.this.keys[i]) || item != IntByteHashMap.this.values[i]) continue;
                IntByteHashMap.this.removeKey(IntByteHashMap.this.keys[i]);
            }
            return oldSize != IntByteHashMap.this.size();
        }

        public boolean retainAll(ByteIterable source) {
            int oldSize = IntByteHashMap.this.size();
            Object sourceSet = source instanceof ByteSet ? (ByteSet)source : source.toSet();
            IntByteHashMap retained = IntByteHashMap.this.select(new IntBytePredicate((ByteSet)sourceSet){
                final /* synthetic */ ByteSet val$sourceSet;
                {
                    this.val$sourceSet = byteSet;
                }

                public boolean accept(int key, byte value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                IntByteHashMap.access$302(IntByteHashMap.this, retained.keys);
                IntByteHashMap.access$502(IntByteHashMap.this, retained.values);
                IntByteHashMap.this.sentinelValues = retained.sentinelValues;
                IntByteHashMap.this.occupiedWithData = retained.occupiedWithData;
                IntByteHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }
    }

    private class KeySet
    extends AbstractMutableIntKeySet {
        private KeySet() {
        }

        protected MutableIntKeysMap getOuter() {
            return IntByteHashMap.this;
        }

        protected AbstractMutableByteValuesMap.SentinelValues getSentinelValues() {
            return IntByteHashMap.this.sentinelValues;
        }

        protected int getKeyAtIndex(int index) {
            return IntByteHashMap.this.keys[index];
        }

        protected int getTableSize() {
            return IntByteHashMap.this.keys.length;
        }

        public MutableIntIterator intIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(IntIterable source) {
            int oldSize = IntByteHashMap.this.size();
            Object sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
            IntByteHashMap retained = IntByteHashMap.this.select(new IntBytePredicate((IntSet)sourceSet){
                final /* synthetic */ IntSet val$sourceSet;
                {
                    this.val$sourceSet = intSet;
                }

                public boolean accept(int key, byte value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                IntByteHashMap.access$302(IntByteHashMap.this, retained.keys);
                IntByteHashMap.access$502(IntByteHashMap.this, retained.values);
                IntByteHashMap.this.sentinelValues = retained.sentinelValues;
                IntByteHashMap.this.occupiedWithData = retained.occupiedWithData;
                IntByteHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(int ... source) {
            return this.retainAll(IntHashSet.newSetWith(source));
        }

        public IntSet freeze() {
            IntByteHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (IntByteHashMap.this.sentinelValues != null) {
                containsZeroKey = ((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((IntByteHashMap)IntByteHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableIntMapKeySet(IntByteHashMap.this.keys, IntByteHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }
    }

    private class KeySetIterator
    implements MutableIntIterator {
        private int count;
        private int position;
        private int lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < IntByteHashMap.this.size();
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntByteHashMap.this.containsKey(0)) {
                    this.lastKey = 0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntByteHashMap.this.containsKey(1)) {
                    this.lastKey = 1;
                    return this.lastKey;
                }
            }
            int[] keys = IntByteHashMap.this.keys;
            while (!IntByteHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            IntByteHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyIntIterable {
        private KeysView() {
        }

        public IntIterator intIterator() {
            return new UnmodifiableIntIterator((IntIterator)new KeySetIterator());
        }

        public void forEach(IntProcedure procedure) {
            IntByteHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalByteIterator
    implements MutableByteIterator {
        private int count;
        private int position;
        private int lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalByteIterator() {
        }

        public boolean hasNext() {
            return this.count < IntByteHashMap.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntByteHashMap.this.containsKey(0)) {
                    this.lastKey = 0;
                    return IntByteHashMap.this.get(0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntByteHashMap.this.containsKey(1)) {
                    this.lastKey = 1;
                    return IntByteHashMap.this.get(1);
                }
            }
            int[] keys = IntByteHashMap.this.keys;
            while (!IntByteHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            byte result = IntByteHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            IntByteHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

