/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.strategy.immutable;

import com.gs.collections.api.block.HashingStrategy;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.map.ImmutableMap;
import com.gs.collections.impl.block.procedure.checked.CheckedProcedure2;
import com.gs.collections.impl.map.strategy.mutable.UnifiedMapWithHashingStrategy;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImmutableMapWithHashingStrategySerializationProxy<K, V>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ImmutableMap<K, V> map;
    private HashingStrategy<? super K> hashingStrategy;

    public ImmutableMapWithHashingStrategySerializationProxy() {
    }

    ImmutableMapWithHashingStrategySerializationProxy(ImmutableMap<K, V> map, HashingStrategy<? super K> hashingStrategy) {
        this.map = map;
        this.hashingStrategy = hashingStrategy;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeObject(this.hashingStrategy);
        out.writeInt(this.map.size());
        try {
            this.map.forEachKeyValue((Procedure2)new CheckedProcedure2<K, V>(){

                @Override
                public void safeValue(K key, V value) throws IOException {
                    out.writeObject(key);
                    out.writeObject(value);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        HashingStrategy strategy = (HashingStrategy)in.readObject();
        int size = in.readInt();
        UnifiedMapWithHashingStrategy deserializedMap = UnifiedMapWithHashingStrategy.newMap(strategy);
        for (int i = 0; i < size; ++i) {
            deserializedMap.put(in.readObject(), in.readObject());
        }
        this.map = deserializedMap.toImmutable();
    }

    protected Object readResolve() {
        return this.map;
    }
}

