/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.factory.stack.primitive.MutableFloatStackFactory;
import com.gs.collections.api.stack.primitive.MutableFloatStack;
import com.gs.collections.impl.stack.mutable.primitive.FloatArrayStack;

public class MutableFloatStackFactoryImpl
implements MutableFloatStackFactory {
    public MutableFloatStack empty() {
        return new FloatArrayStack();
    }

    public MutableFloatStack of() {
        return this.empty();
    }

    public MutableFloatStack with() {
        return this.empty();
    }

    public MutableFloatStack of(float ... items) {
        return this.with(items);
    }

    public MutableFloatStack with(float ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return FloatArrayStack.newStackWith(items);
    }

    public MutableFloatStack ofAll(FloatIterable items) {
        return this.withAll(items);
    }

    public MutableFloatStack withAll(FloatIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return FloatArrayStack.newStack(items);
    }

    public MutableFloatStack ofAllReversed(FloatIterable items) {
        return this.withAllReversed(items);
    }

    public MutableFloatStack withAllReversed(FloatIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return FloatArrayStack.newStackFromTopToBottom(items);
    }
}

