/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.string.StringHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PGPrinter {
    private static IPrinter s_aOut = new PSPrinter(System.out, false);
    private static IPrinter s_aErr = new PSPrinter(System.err, false);

    private PGPrinter() {
    }

    public static void init(@Nonnull IPrinter iPrinter) {
        PGPrinter.init(iPrinter, iPrinter);
    }

    public static void init(@Nonnull IPrinter iPrinter, @Nonnull IPrinter iPrinter2) {
        ValueEnforcer.notNull((Object)iPrinter, (String)"PrinterInfo");
        ValueEnforcer.notNull((Object)iPrinter2, (String)"PrinterError");
        s_aOut = iPrinter;
        s_aErr = iPrinter2;
    }

    public static void debug(@Nonnull String string) {
        s_aOut.println(string);
    }

    public static void info() {
        s_aOut.println(null);
    }

    public static void info(@Nonnull String string) {
        s_aOut.println(string);
    }

    public static void warn(@Nonnull String string) {
        PGPrinter.warn(string, null);
    }

    public static void warn(@Nonnull String string, @Nullable Throwable throwable) {
        s_aErr.println(string);
        if (throwable != null) {
            s_aErr.println(StackTraceHelper.getStackAsString((Throwable)throwable));
        }
    }

    public static void error(@Nonnull String string) {
        PGPrinter.error(string, null);
    }

    public static void error(@Nonnull String string, @Nullable Throwable throwable) {
        s_aErr.println(string);
        if (throwable != null) {
            s_aErr.println(StackTraceHelper.getStackAsString((Throwable)throwable));
        }
    }

    public static void flush() {
        s_aOut.flush();
        s_aErr.flush();
    }

    public static void close() throws Exception {
        s_aOut.close();
        s_aErr.close();
    }

    @Nonnull
    public static PrintWriter getOutWriter() {
        return new PrintWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()));
    }

    @Nonnull
    public static PrintWriter getErrWriter() {
        return new PrintWriter(new OutputStreamWriter((OutputStream)System.err, Charset.defaultCharset()));
    }

    public static final class PSPrinter
    implements IPrinter {
        private final PrintStream m_aPS;
        private final boolean m_bCanClose;

        public PSPrinter(@Nonnull PrintStream printStream, boolean bl) {
            this.m_aPS = printStream;
            this.m_bCanClose = bl;
        }

        @Override
        public void close() throws IOException {
            if (this.m_bCanClose) {
                this.m_aPS.close();
            }
        }

        @Override
        public void println(@Nonnull String string) {
            if (StringHelper.hasNoText((String)string)) {
                this.m_aPS.println();
            } else {
                this.m_aPS.println(string);
            }
        }

        @Override
        public void flush() {
            this.m_aPS.flush();
        }
    }

    public static interface IPrinter
    extends AutoCloseable {
        public void println(@Nonnull String var1);

        public void flush();
    }
}

