/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.pgcc.parser.CharStream;
import java.io.IOException;

public abstract class AbstractCharStream
implements CharStream {
    public static final int DEFAULT_BUF_SIZE = 4096;
    protected int bufpos = -1;
    protected int bufsize;
    protected int available;
    protected int tokenBegin;
    protected int[] bufline;
    protected int[] bufcolumn;
    protected int column = 0;
    protected int line = 1;
    protected boolean prevCharIsCR = false;
    protected boolean prevCharIsLF = false;
    protected char[] buffer;
    protected int maxNextCharInd = 0;
    protected int inBuf = 0;
    private int tabSize = 1;
    protected char[] nextCharBuf;
    protected int nextCharInd = -1;
    private boolean trackLineColumn = true;

    static final int hexval(char c) throws IOException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IOException("Invalid hex char '" + c + "' provided!");
    }

    @Override
    public void setTabSize(int n) {
        this.tabSize = n;
    }

    @Override
    public int getTabSize() {
        return this.tabSize;
    }

    protected void expandBuff(boolean bl) {
        char[] cArray = new char[this.bufsize + 2048];
        int[] nArray = new int[this.bufsize + 2048];
        int[] nArray2 = new int[this.bufsize + 2048];
        try {
            if (bl) {
                System.arraycopy(this.buffer, this.tokenBegin, cArray, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.buffer, 0, cArray, this.bufsize - this.tokenBegin, this.bufpos);
                this.buffer = cArray;
                System.arraycopy(this.bufline, this.tokenBegin, nArray, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.bufline, 0, nArray, this.bufsize - this.tokenBegin, this.bufpos);
                this.bufline = nArray;
                System.arraycopy(this.bufcolumn, this.tokenBegin, nArray2, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.bufcolumn, 0, nArray2, this.bufsize - this.tokenBegin, this.bufpos);
                this.bufcolumn = nArray2;
                this.bufpos += this.bufsize - this.tokenBegin;
                this.maxNextCharInd = this.bufpos;
            } else {
                System.arraycopy(this.buffer, this.tokenBegin, cArray, 0, this.bufsize - this.tokenBegin);
                this.buffer = cArray;
                System.arraycopy(this.bufline, this.tokenBegin, nArray, 0, this.bufsize - this.tokenBegin);
                this.bufline = nArray;
                System.arraycopy(this.bufcolumn, this.tokenBegin, nArray2, 0, this.bufsize - this.tokenBegin);
                this.bufcolumn = nArray2;
                this.bufpos -= this.tokenBegin;
                this.maxNextCharInd = this.bufpos;
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        this.bufsize += 2048;
        this.available = this.bufsize;
        this.tokenBegin = 0;
    }

    protected abstract int streamRead(char[] var1, int var2, int var3) throws IOException;

    protected abstract void streamClose() throws IOException;

    protected void fillBuff() throws IOException {
        if (this.maxNextCharInd == this.available) {
            if (this.available == this.bufsize) {
                if (this.tokenBegin > 2048) {
                    this.maxNextCharInd = 0;
                    this.bufpos = 0;
                    this.available = this.tokenBegin;
                } else if (this.tokenBegin < 0) {
                    this.maxNextCharInd = 0;
                    this.bufpos = 0;
                } else {
                    this.expandBuff(false);
                }
            } else if (this.available > this.tokenBegin) {
                this.available = this.bufsize;
            } else if (this.tokenBegin - this.available < 2048) {
                this.expandBuff(true);
            } else {
                this.available = this.tokenBegin;
            }
        }
        try {
            int n = this.streamRead(this.buffer, this.maxNextCharInd, this.available - this.maxNextCharInd);
            if (n == -1) {
                this.streamClose();
                throw new IOException();
            }
            this.maxNextCharInd += n;
            return;
        }
        catch (IOException iOException) {
            --this.bufpos;
            this.backup(0);
            if (this.tokenBegin == -1) {
                this.tokenBegin = this.bufpos;
            }
            throw iOException;
        }
    }

    @Override
    public char beginToken() throws IOException {
        this.tokenBegin = -1;
        char c = this.readChar();
        this.tokenBegin = this.bufpos;
        return c;
    }

    protected void updateLineColumn(char c) {
        ++this.column;
        if (this.prevCharIsLF) {
            this.prevCharIsLF = false;
            this.column = 1;
            ++this.line;
        } else if (this.prevCharIsCR) {
            this.prevCharIsCR = false;
            if (c == '\n') {
                this.prevCharIsLF = true;
            } else {
                this.column = 1;
                ++this.line;
            }
        }
        switch (c) {
            case '\r': {
                this.prevCharIsCR = true;
                break;
            }
            case '\n': {
                this.prevCharIsLF = true;
                break;
            }
            case '\t': {
                --this.column;
                this.column += this.tabSize - this.column % this.tabSize;
                break;
            }
        }
        this.bufline[this.bufpos] = this.line;
        this.bufcolumn[this.bufpos] = this.column;
    }

    @Override
    public char readChar() throws IOException {
        if (this.inBuf > 0) {
            --this.inBuf;
            if (++this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            return this.buffer[this.bufpos];
        }
        ++this.bufpos;
        if (this.bufpos >= this.maxNextCharInd) {
            this.fillBuff();
        }
        char c = this.buffer[this.bufpos];
        if (this.trackLineColumn) {
            this.updateLineColumn(c);
        }
        return c;
    }

    @Override
    public int getBeginColumn() {
        return this.bufcolumn[this.tokenBegin];
    }

    @Override
    public int getBeginLine() {
        return this.bufline[this.tokenBegin];
    }

    @Override
    public int getEndColumn() {
        return this.bufcolumn[this.bufpos];
    }

    @Override
    public int getEndLine() {
        return this.bufline[this.bufpos];
    }

    @Override
    public void backup(int n) {
        this.inBuf += n;
        this.bufpos -= n;
        if (this.bufpos < 0) {
            this.bufpos += this.bufsize;
        }
    }

    public AbstractCharStream(int n, int n2, int n3) {
        this.line = n;
        this.column = n2 - 1;
        this.bufsize = n3;
        this.available = n3;
        this.buffer = new char[n3];
        this.bufline = new int[n3];
        this.bufcolumn = new int[n3];
        this.nextCharBuf = new char[4096];
    }

    public void reInit(int n, int n2, int n3) {
        this.line = n;
        this.column = n2 - 1;
        if (this.buffer == null || n3 != this.buffer.length) {
            this.bufsize = n3;
            this.available = n3;
            this.buffer = new char[n3];
            this.bufline = new int[n3];
            this.bufcolumn = new int[n3];
            this.nextCharBuf = new char[4096];
        }
        this.prevCharIsCR = false;
        this.prevCharIsLF = false;
        this.maxNextCharInd = 0;
        this.inBuf = 0;
        this.tokenBegin = 0;
        this.bufpos = -1;
        this.nextCharInd = -1;
    }

    @Override
    public String getImage() {
        if (this.bufpos >= this.tokenBegin) {
            return new String(this.buffer, this.tokenBegin, this.bufpos - this.tokenBegin + 1);
        }
        return new String(this.buffer, this.tokenBegin, this.bufsize - this.tokenBegin) + new String(this.buffer, 0, this.bufpos + 1);
    }

    @Override
    public char[] getSuffix(int n) {
        char[] cArray = new char[n];
        if (this.bufpos + 1 >= n) {
            System.arraycopy(this.buffer, this.bufpos - n + 1, cArray, 0, n);
        } else {
            System.arraycopy(this.buffer, this.bufsize - (n - this.bufpos - 1), cArray, 0, n - this.bufpos - 1);
            System.arraycopy(this.buffer, 0, cArray, n - this.bufpos - 1, this.bufpos + 1);
        }
        return cArray;
    }

    @Override
    public void done() {
        this.nextCharBuf = null;
        this.buffer = null;
        this.bufline = null;
        this.bufcolumn = null;
    }

    public void adjustBeginLineColumn(int n, int n2) {
        int n3;
        int n4 = this.tokenBegin;
        int n5 = n;
        int n6 = this.bufpos >= this.tokenBegin ? this.bufpos - this.tokenBegin + this.inBuf + 1 : this.bufsize - this.tokenBegin + this.bufpos + 1 + this.inBuf;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (n3 = 0; n3 < n6 && this.bufline[n7 = n4 % this.bufsize] == this.bufline[n8 = ++n4 % this.bufsize]; ++n3) {
            this.bufline[n7] = n5;
            n9 = n10 + this.bufcolumn[n8] - this.bufcolumn[n7];
            this.bufcolumn[n7] = n2 + n10;
            n10 = n9;
        }
        if (n3 < n6) {
            this.bufline[n7] = n5++;
            this.bufcolumn[n7] = n2 + n10;
            while (n3++ < n6) {
                n7 = n4 % this.bufsize;
                if (this.bufline[n7] != this.bufline[++n4 % this.bufsize]) {
                    this.bufline[n7] = n5++;
                    continue;
                }
                this.bufline[n7] = n5;
            }
        }
        this.line = this.bufline[n7];
        this.column = this.bufcolumn[n7];
    }

    @Override
    public void setTrackLineColumn(boolean bl) {
        this.trackLineColumn = bl;
    }

    @Override
    public boolean isTrackLineColumn() {
        return this.trackLineColumn;
    }
}

