/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.state.ESuccess;
import com.helger.pgcc.PGPrinter;
import com.helger.pgcc.output.EOutputLanguage;
import com.helger.pgcc.output.cpp.OtherFilesGenCPP;
import com.helger.pgcc.output.java.FilesJava;
import com.helger.pgcc.output.java.OtherFilesGenJava;
import com.helger.pgcc.parser.ExpRStringLiteral;
import com.helger.pgcc.parser.Expansion;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.JavaCCParser;
import com.helger.pgcc.parser.JavaCCParserInternals;
import com.helger.pgcc.parser.LexGenCpp;
import com.helger.pgcc.parser.LexGenJava;
import com.helger.pgcc.parser.LookaheadWalk;
import com.helger.pgcc.parser.MatchInfo;
import com.helger.pgcc.parser.MetaParseException;
import com.helger.pgcc.parser.NfaState;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.ParseException;
import com.helger.pgcc.parser.ParseGenCPP;
import com.helger.pgcc.parser.ParseGenJava;
import com.helger.pgcc.parser.Semanticize;
import com.helger.pgcc.parser.StreamProvider;
import com.helger.pgcc.utils.EOptionType;
import com.helger.pgcc.utils.OptionInfo;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Set;
import javax.annotation.Nonnull;

public class Main {
    private Main() {
    }

    private static void _showHelpMessage() {
        PGPrinter.info("Usage:");
        PGPrinter.info("    pgcc option-settings inputfile");
        PGPrinter.info();
        PGPrinter.info("\"option-settings\" is a sequence of settings separated by spaces.");
        PGPrinter.info("Each option setting must be of one of the following forms:");
        PGPrinter.info();
        PGPrinter.info("    -optionname=value (e.g., -STATIC=false)");
        PGPrinter.info("    -optionname:value (e.g., -STATIC:false)");
        PGPrinter.info("    -optionname       (equivalent to -optionname=true.  e.g., -STATIC)");
        PGPrinter.info("    -NOoptionname     (equivalent to -optionname=false. e.g., -NOSTATIC)");
        PGPrinter.info();
        PGPrinter.info("Option settings are not case-sensitive, so one can say \"-nOsTaTiC\" instead");
        PGPrinter.info("of \"-NOSTATIC\".  Option values must be appropriate for the corresponding");
        PGPrinter.info("option, and must be either an integer, a boolean, or a string value.");
        PGPrinter.info();
        Main._printOptions();
        PGPrinter.info("EXAMPLE:");
        PGPrinter.info("    pgcc -OUTPUT_DIRECTORY=target/code -LOOKAHEAD:2 -debug_parser mygrammar.jj");
        PGPrinter.info();
    }

    private static void _printOptions() {
        Set<OptionInfo> set = Options.getUserOptions();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (OptionInfo optionInfo : set) {
            int n4 = optionInfo.getName().length();
            switch (optionInfo.getType()) {
                case INTEGER: {
                    n = n4 > n ? n4 : n;
                    break;
                }
                case BOOLEAN: {
                    n2 = n4 > n2 ? n4 : n2;
                    break;
                }
                case STRING: {
                    n3 = n4 > n3 ? n4 : n3;
                    break;
                }
            }
        }
        if (n > 0) {
            PGPrinter.info("The integer valued options are:");
            PGPrinter.info();
            for (OptionInfo optionInfo : set) {
                Main._printOptionInfo(EOptionType.INTEGER, optionInfo, n);
            }
            PGPrinter.info();
        }
        if (n2 > 0) {
            PGPrinter.info("The boolean valued options are:");
            PGPrinter.info();
            for (OptionInfo optionInfo : set) {
                Main._printOptionInfo(EOptionType.BOOLEAN, optionInfo, n2);
            }
            PGPrinter.info();
        }
        if (n3 > 0) {
            PGPrinter.info("The string valued options are:");
            PGPrinter.info();
            for (OptionInfo optionInfo : set) {
                Main._printOptionInfo(EOptionType.STRING, optionInfo, n3);
            }
            PGPrinter.info();
        }
    }

    private static void _printOptionInfo(EOptionType eOptionType, OptionInfo optionInfo, int n) {
        if (optionInfo.getType() == eOptionType) {
            Comparable<?> comparable = optionInfo.getDefault();
            PGPrinter.info("    " + Main._padRight(optionInfo.getName(), n + 1) + (comparable == null ? "" : "(default : " + (comparable.toString().length() == 0 ? "<<empty>>" : comparable) + ")"));
        }
    }

    private static String _padRight(String string, int n) {
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        int n3 = n - n2;
        StringBuilder stringBuilder = new StringBuilder(n3);
        stringBuilder.append(string);
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static void main(String ... stringArray) throws IOException {
        ESuccess eSuccess = Main.mainProgram(stringArray);
        System.exit(eSuccess.isSuccess() ? 0 : 1);
    }

    @Nonnull
    public static ESuccess mainProgram(String ... stringArray) throws IOException {
        Object object;
        Main.reInitAll();
        JavaCCGlobals.bannerLine("ParserGeneratorCC", "");
        if (stringArray.length == 0) {
            PGPrinter.info();
            Main._showHelpMessage();
            return ESuccess.FAILURE;
        }
        PGPrinter.info("(type \"pgcc\" with no arguments for help)");
        if (Options.isOption(stringArray[stringArray.length - 1])) {
            PGPrinter.info("Last argument \"" + stringArray[stringArray.length - 1] + "\" is not a filename.");
            return ESuccess.FAILURE;
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (!Options.isOption(stringArray[i])) {
                PGPrinter.info("Argument \"" + stringArray[i] + "\" must be an option setting.");
                return ESuccess.FAILURE;
            }
            Options.setCmdLineOption(stringArray[i]);
        }
        JavaCCParser javaCCParser = null;
        try {
            object = new File(stringArray[stringArray.length - 1]);
            if (!((File)object).exists()) {
                PGPrinter.info("File " + stringArray[stringArray.length - 1] + " not found.");
                return ESuccess.FAILURE;
            }
            if (((File)object).isDirectory()) {
                PGPrinter.info(stringArray[stringArray.length - 1] + " is a directory. Please use a valid file name.");
                return ESuccess.FAILURE;
            }
            NonBlockingBufferedReader nonBlockingBufferedReader = FileHelper.getBufferedReader((File)new File(stringArray[stringArray.length - 1]), (Charset)Options.getGrammarEncoding());
            if (nonBlockingBufferedReader == null) {
                PGPrinter.info("File " + stringArray[stringArray.length - 1] + " not found.");
                return ESuccess.FAILURE;
            }
            javaCCParser = new JavaCCParser(new StreamProvider((Reader)nonBlockingBufferedReader));
        }
        catch (SecurityException securityException) {
            PGPrinter.info("Security violation while trying to open " + stringArray[stringArray.length - 1]);
            return ESuccess.FAILURE;
        }
        try {
            PGPrinter.info("Reading from file " + stringArray[stringArray.length - 1] + " ...");
            JavaCCGlobals.s_origFileName = JavaCCGlobals.s_fileName = stringArray[stringArray.length - 1];
            JavaCCGlobals.s_jjtreeGenerated = JavaCCGlobals.isGeneratedBy("JJTree", stringArray[stringArray.length - 1]);
            JavaCCGlobals.s_toolNames = JavaCCGlobals.getToolNames(stringArray[stringArray.length - 1]);
            javaCCParser.javacc_input();
            object = Options.getOutputLanguage();
            boolean bl = ((EOutputLanguage)((Object)object)).isJava() && Options.getJavaTemplateType().equals("modern");
            JavaCCGlobals.createOutputDir(Options.getOutputDirectory());
            if (Options.isUnicodeInput()) {
                NfaState.s_unicodeWarningGiven = true;
                JavaCCErrors.note("UNICODE_INPUT option is specified. Please make sure you create the parser/lexer using a Reader with the correct character encoding.");
            }
            Semanticize.start();
            boolean bl2 = Options.isBuildParser();
            switch (1.$SwitchMap$com$helger$pgcc$output$EOutputLanguage[((Enum)object).ordinal()]) {
                case 1: {
                    if (bl2) {
                        new ParseGenJava().start(bl);
                    }
                    new LexGenJava().start();
                    Options.setStringOption("PARSER_NAME", JavaCCGlobals.s_cu_name);
                    OtherFilesGenJava.start(bl);
                    break;
                }
                case 2: {
                    if (bl2) {
                        new ParseGenCPP().start();
                    }
                    if (bl2) {
                        new LexGenCpp().start();
                    }
                    Options.setStringOption("PARSER_NAME", JavaCCGlobals.s_cu_name);
                    OtherFilesGenCPP.start();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled language!");
                }
            }
            int n = JavaCCErrors.getErrorCount();
            int n2 = JavaCCErrors.getWarningCount();
            if (n == 0 && (bl2 || Options.isBuildTokenManager())) {
                if (n2 == 0) {
                    if (bl2) {
                        PGPrinter.info("Parser generated successfully.");
                    }
                } else {
                    PGPrinter.info("Parser generated with 0 errors and " + n2 + " warnings.");
                }
            } else {
                PGPrinter.info("Detected " + n + " error(s) and " + n2 + " warning(s).");
            }
            return ESuccess.valueOf((n == 0 ? 1 : 0) != 0);
        }
        catch (MetaParseException metaParseException) {
            PGPrinter.error("Detected " + JavaCCErrors.getErrorCount() + " errors and " + JavaCCErrors.getWarningCount() + " warnings.");
        }
        catch (ParseException parseException) {
            PGPrinter.error("Detected " + (JavaCCErrors.getErrorCount() + 1) + " errors and " + JavaCCErrors.getWarningCount() + " warnings.", parseException);
        }
        return ESuccess.FAILURE;
    }

    public static void reInitAll() {
        Expansion.reInit();
        JavaCCErrors.reInit();
        JavaCCGlobals.reInitStatic();
        Options.init();
        JavaCCParserInternals.reInit();
        ExpRStringLiteral.reInit();
        FilesJava.reInit();
        NfaState.reInit();
        MatchInfo.reInitStatic();
        LookaheadWalk.reInit();
        Semanticize.reInit();
        OtherFilesGenJava.reInit();
        LexGenJava.reInit();
    }
}

