/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.source;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.io.source.ByteUtils;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfTokenizer
implements Closeable {
    public static final boolean[] delims = new boolean[]{true, true, false, false, false, false, false, false, false, false, true, true, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, true, false, false, true, true, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    public static final byte[] Obj = ByteUtils.getIsoBytes("obj");
    public static final byte[] R = ByteUtils.getIsoBytes("R");
    public static final byte[] Xref = ByteUtils.getIsoBytes("xref");
    public static final byte[] Startxref = ByteUtils.getIsoBytes("startxref");
    public static final byte[] Stream = ByteUtils.getIsoBytes("stream");
    public static final byte[] Trailer = ByteUtils.getIsoBytes("trailer");
    public static final byte[] N = ByteUtils.getIsoBytes("n");
    public static final byte[] F = ByteUtils.getIsoBytes("f");
    public static final byte[] Null = ByteUtils.getIsoBytes("null");
    public static final byte[] True = ByteUtils.getIsoBytes("true");
    public static final byte[] False = ByteUtils.getIsoBytes("false");
    protected TokenType type;
    protected int reference;
    protected int generation;
    protected boolean hexString;
    protected ByteBuffer outBuf;
    private final RandomAccessFileOrArray file;
    private boolean closeStream = true;

    public PdfTokenizer(RandomAccessFileOrArray file) {
        this.file = file;
        this.outBuf = new ByteBuffer();
    }

    public void seek(long pos) {
        this.file.seek(pos);
    }

    public void readFully(byte[] bytes) throws IOException {
        this.file.readFully(bytes);
    }

    public long getPosition() {
        return this.file.getPosition();
    }

    @Override
    public void close() throws IOException {
        if (this.closeStream) {
            this.file.close();
        }
    }

    public long length() {
        return this.file.length();
    }

    public int read() throws IOException {
        return this.file.read();
    }

    public String readString(int size) throws IOException {
        int ch;
        StringBuilder buf = new StringBuilder();
        while (size-- > 0 && (ch = this.read()) != -1) {
            buf.append((char)ch);
        }
        return buf.toString();
    }

    public TokenType getTokenType() {
        return this.type;
    }

    public byte[] getByteContent() {
        return this.outBuf.toByteArray();
    }

    public String getStringValue() {
        return new String(this.outBuf.getInternalBuffer(), 0, this.outBuf.size());
    }

    public byte[] getDecodedStringContent() {
        return PdfTokenizer.decodeStringContent(this.outBuf.getInternalBuffer(), 0, this.outBuf.size() - 1, this.isHexString());
    }

    public boolean tokenValueEqualsTo(byte[] cmp) {
        if (cmp == null) {
            return false;
        }
        int size = cmp.length;
        if (this.outBuf.size() != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (cmp[i] == this.outBuf.getInternalBuffer()[i]) continue;
            return false;
        }
        return true;
    }

    public int getObjNr() {
        return this.reference;
    }

    public int getGenNr() {
        return this.generation;
    }

    public void backOnePosition(int ch) {
        if (ch != -1) {
            this.file.pushBack((byte)ch);
        }
    }

    public int getHeaderOffset() throws IOException {
        String str = this.readString(1024);
        int idx = str.indexOf("%PDF-");
        if (idx < 0 && (idx = str.indexOf("%FDF-")) < 0) {
            throw new com.itextpdf.io.exceptions.IOException("PDF header not found.", this);
        }
        return idx;
    }

    public String checkPdfHeader() throws IOException {
        this.file.seek(0L);
        String str = this.readString(1024);
        int idx = str.indexOf("%PDF-");
        if (idx != 0) {
            throw new com.itextpdf.io.exceptions.IOException("PDF header not found.", this);
        }
        return str.substring(idx + 1, idx + 8);
    }

    public void checkFdfHeader() throws IOException {
        this.file.seek(0L);
        String str = this.readString(1024);
        int idx = str.indexOf("%FDF-");
        if (idx != 0) {
            throw new com.itextpdf.io.exceptions.IOException("FDF startxref not found.", this);
        }
    }

    public long getStartxref() throws IOException {
        int arrLength = 1024;
        long fileLength = this.file.length();
        long pos = fileLength - (long)arrLength;
        if (pos < 1L) {
            pos = 1L;
        }
        while (pos > 0L) {
            this.file.seek(pos);
            String str = this.readString(arrLength);
            int idx = str.lastIndexOf("startxref");
            if (idx >= 0) {
                return pos + (long)idx;
            }
            pos = pos - (long)arrLength + 9L;
        }
        throw new com.itextpdf.io.exceptions.IOException("PDF startxref not found.", this);
    }

    public void nextValidToken() throws IOException {
        int level = 0;
        byte[] n1 = null;
        byte[] n2 = null;
        long ptr = 0L;
        while (this.nextToken()) {
            if (this.type == TokenType.Comment) continue;
            switch (level) {
                case 0: {
                    if (this.type != TokenType.Number) {
                        return;
                    }
                    ptr = this.file.getPosition();
                    n1 = this.getByteContent();
                    ++level;
                    break;
                }
                case 1: {
                    if (this.type != TokenType.Number) {
                        this.file.seek(ptr);
                        this.type = TokenType.Number;
                        this.outBuf.reset().append(n1);
                        return;
                    }
                    n2 = this.getByteContent();
                    ++level;
                    break;
                }
                case 2: {
                    if (this.type == TokenType.Other) {
                        if (this.tokenValueEqualsTo(R)) {
                            assert (n2 != null);
                            this.type = TokenType.Ref;
                            try {
                                this.reference = Integer.parseInt(new String(n1));
                                this.generation = Integer.parseInt(new String(n2));
                            }
                            catch (Exception ex) {
                                Logger logger = LoggerFactory.getLogger(PdfTokenizer.class);
                                logger.error(MessageFormatUtil.format((String)"Invalid indirect reference {0} {1} R", (Object[])new Object[]{new String(n1), new String(n2)}));
                                this.reference = -1;
                                this.generation = 0;
                            }
                            return;
                        }
                        if (this.tokenValueEqualsTo(Obj)) {
                            assert (n2 != null);
                            this.type = TokenType.Obj;
                            this.reference = Integer.parseInt(new String(n1));
                            this.generation = Integer.parseInt(new String(n2));
                            return;
                        }
                    }
                    this.file.seek(ptr);
                    this.type = TokenType.Number;
                    this.outBuf.reset().append(n1);
                    return;
                }
            }
        }
        if (level == 1) {
            this.type = TokenType.Number;
            this.outBuf.reset().append(n1);
        }
    }

    public boolean nextToken() throws IOException {
        int ch;
        this.outBuf.reset();
        while ((ch = this.file.read()) != -1 && PdfTokenizer.isWhitespace(ch)) {
        }
        if (ch == -1) {
            this.type = TokenType.EndOfFile;
            return false;
        }
        switch (ch) {
            case 91: {
                this.type = TokenType.StartArray;
                break;
            }
            case 93: {
                this.type = TokenType.EndArray;
                break;
            }
            case 47: {
                this.type = TokenType.Name;
                while (!delims[(ch = this.file.read()) + 1]) {
                    this.outBuf.append(ch);
                }
                this.backOnePosition(ch);
                break;
            }
            case 62: {
                ch = this.file.read();
                if (ch != 62) {
                    this.throwError("'>' not expected.", new Object[0]);
                }
                this.type = TokenType.EndDic;
                break;
            }
            case 60: {
                int v1 = this.file.read();
                if (v1 == 60) {
                    this.type = TokenType.StartDic;
                    break;
                }
                this.type = TokenType.String;
                this.hexString = true;
                int v2 = 0;
                while (true) {
                    if (PdfTokenizer.isWhitespace(v1)) {
                        v1 = this.file.read();
                        continue;
                    }
                    if (v1 == 62) break;
                    this.outBuf.append(v1);
                    v1 = ByteBuffer.getHex(v1);
                    if (v1 < 0) break;
                    v2 = this.file.read();
                    while (PdfTokenizer.isWhitespace(v2)) {
                        v2 = this.file.read();
                    }
                    if (v2 == 62) break;
                    this.outBuf.append(v2);
                    v2 = ByteBuffer.getHex(v2);
                    if (v2 < 0) break;
                    v1 = this.file.read();
                }
                if (v1 >= 0 && v2 >= 0) break;
                this.throwError("Error reading string.", new Object[0]);
                break;
            }
            case 37: {
                this.type = TokenType.Comment;
                while ((ch = this.file.read()) != -1 && ch != 13 && ch != 10) {
                }
                break;
            }
            case 40: {
                this.type = TokenType.String;
                this.hexString = false;
                int nesting = 0;
                while ((ch = this.file.read()) != -1) {
                    if (ch == 40) {
                        ++nesting;
                    } else if (ch == 41) {
                        if (--nesting == -1) {
                            break;
                        }
                    } else if (ch == 92) {
                        this.outBuf.append(92);
                        ch = this.file.read();
                        if (ch < 0) break;
                    }
                    this.outBuf.append(ch);
                }
                if (ch != -1) break;
                this.throwError("Error reading string.", new Object[0]);
                break;
            }
            default: {
                if (ch == 45 || ch == 43 || ch == 46 || ch >= 48 && ch <= 57) {
                    this.type = TokenType.Number;
                    boolean isReal = false;
                    int numberOfMinuses = 0;
                    if (ch == 45) {
                        do {
                            ++numberOfMinuses;
                        } while ((ch = this.file.read()) == 45);
                        this.outBuf.append(45);
                    } else {
                        this.outBuf.append(ch);
                        ch = this.file.read();
                    }
                    while (ch >= 48 && ch <= 57) {
                        this.outBuf.append(ch);
                        ch = this.file.read();
                    }
                    if (ch == 46) {
                        isReal = true;
                        this.outBuf.append(ch);
                        ch = this.file.read();
                        int numberOfMinusesAfterDot = 0;
                        if (ch == 45) {
                            ++numberOfMinusesAfterDot;
                            ch = this.file.read();
                        }
                        while (ch >= 48 && ch <= 57) {
                            if (numberOfMinusesAfterDot == 0) {
                                this.outBuf.append(ch);
                            }
                            ch = this.file.read();
                        }
                    }
                    if (numberOfMinuses > 1 && !isReal) {
                        this.outBuf.reset();
                        this.outBuf.append(48);
                    }
                } else {
                    this.type = TokenType.Other;
                    do {
                        this.outBuf.append(ch);
                    } while (!delims[(ch = this.file.read()) + 1]);
                }
                if (ch == -1) break;
                this.backOnePosition(ch);
            }
        }
        return true;
    }

    public long getLongValue() {
        return Long.parseLong(this.getStringValue());
    }

    public int getIntValue() {
        return Integer.parseInt(this.getStringValue());
    }

    public boolean isHexString() {
        return this.hexString;
    }

    public boolean isCloseStream() {
        return this.closeStream;
    }

    public void setCloseStream(boolean closeStream) {
        this.closeStream = closeStream;
    }

    public RandomAccessFileOrArray getSafeFile() {
        return this.file.createView();
    }

    protected static byte[] decodeStringContent(byte[] content, int from, int to, boolean hexWriting) {
        ByteBuffer buffer = new ByteBuffer(to - from + 1);
        if (hexWriting) {
            int i = from;
            while (i <= to) {
                int v1 = ByteBuffer.getHex(content[i++]);
                if (i > to) {
                    buffer.append(v1 << 4);
                    break;
                }
                int v2 = content[i++];
                v2 = ByteBuffer.getHex(v2);
                buffer.append((v1 << 4) + v2);
            }
        } else {
            int i = from;
            while (i <= to) {
                int ch;
                if ((ch = content[i++]) == 92) {
                    boolean lineBreak = false;
                    ch = content[i++];
                    switch (ch) {
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                            break;
                        }
                        case 40: 
                        case 41: 
                        case 92: {
                            break;
                        }
                        case 13: {
                            lineBreak = true;
                            if (i > to || content[i++] == 10) break;
                            --i;
                            break;
                        }
                        case 10: {
                            lineBreak = true;
                            break;
                        }
                        default: {
                            if (ch < 48 || ch > 55) break;
                            int octal = ch - 48;
                            if (i > to) {
                                ch = octal;
                                break;
                            }
                            if ((ch = content[i++]) < 48 || ch > 55) {
                                --i;
                                ch = octal;
                                break;
                            }
                            octal = (octal << 3) + ch - 48;
                            if (i > to) {
                                ch = octal;
                                break;
                            }
                            if ((ch = content[i++]) < 48 || ch > 55) {
                                --i;
                                ch = octal;
                                break;
                            }
                            octal = (octal << 3) + ch - 48;
                            ch = octal & 0xFF;
                            break;
                        }
                    }
                    if (lineBreak) {
                        continue;
                    }
                } else if (ch == 13) {
                    ch = 10;
                    if (i <= to && content[i++] != 10) {
                        --i;
                    }
                }
                buffer.append(ch);
            }
        }
        return buffer.toByteArray();
    }

    public static byte[] decodeStringContent(byte[] content, boolean hexWriting) {
        return PdfTokenizer.decodeStringContent(content, 0, content.length - 1, hexWriting);
    }

    public static boolean isWhitespace(int ch) {
        return PdfTokenizer.isWhitespace(ch, true);
    }

    protected static boolean isWhitespace(int ch, boolean isWhitespace) {
        return isWhitespace && ch == 0 || ch == 9 || ch == 10 || ch == 12 || ch == 13 || ch == 32;
    }

    protected static boolean isDelimiter(int ch) {
        return ch == 40 || ch == 41 || ch == 60 || ch == 62 || ch == 91 || ch == 93 || ch == 47 || ch == 37;
    }

    protected static boolean isDelimiterWhitespace(int ch) {
        return delims[ch + 1];
    }

    public void throwError(String error, Object ... messageParams) {
        throw new com.itextpdf.io.exceptions.IOException("Error at file pointer {0}.", (Throwable)((Object)new com.itextpdf.io.exceptions.IOException(error).setMessageParams(messageParams))).setMessageParams(this.file.getPosition());
    }

    public static boolean checkTrailer(ByteBuffer line) {
        if (Trailer.length > line.size()) {
            return false;
        }
        for (int i = 0; i < Trailer.length; ++i) {
            if (Trailer[i] == line.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean readLineSegment(ByteBuffer buffer) throws IOException {
        return this.readLineSegment(buffer, true);
    }

    public boolean readLineSegment(ByteBuffer buffer, boolean isNullWhitespace) throws IOException {
        long cur;
        int c;
        boolean eol = false;
        while (PdfTokenizer.isWhitespace(c = this.read(), isNullWhitespace)) {
        }
        boolean prevWasWhitespace = false;
        while (!eol) {
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    break;
                }
                case 13: {
                    eol = true;
                    cur = this.getPosition();
                    if (this.read() == 10) break;
                    this.seek(cur);
                    break;
                }
                case 9: 
                case 12: 
                case 32: {
                    if (prevWasWhitespace) break;
                    prevWasWhitespace = true;
                    buffer.append((byte)c);
                    break;
                }
                default: {
                    prevWasWhitespace = false;
                    buffer.append((byte)c);
                }
            }
            if (eol || buffer.size() == buffer.capacity()) {
                eol = true;
                continue;
            }
            c = this.read();
        }
        if (buffer.size() == buffer.capacity()) {
            eol = false;
            while (!eol) {
                c = this.read();
                switch (c) {
                    case -1: 
                    case 10: {
                        eol = true;
                        break;
                    }
                    case 13: {
                        eol = true;
                        cur = this.getPosition();
                        if (this.read() == 10) break;
                        this.seek(cur);
                    }
                }
            }
        }
        return c != -1 || !buffer.isEmpty();
    }

    public static int[] checkObjectStart(PdfTokenizer lineTokenizer) {
        try {
            lineTokenizer.seek(0L);
            if (!lineTokenizer.nextToken() || lineTokenizer.getTokenType() != TokenType.Number) {
                return null;
            }
            int num = lineTokenizer.getIntValue();
            if (!lineTokenizer.nextToken() || lineTokenizer.getTokenType() != TokenType.Number) {
                return null;
            }
            int gen = lineTokenizer.getIntValue();
            if (!lineTokenizer.nextToken()) {
                return null;
            }
            if (!Arrays.equals(Obj, lineTokenizer.getByteContent())) {
                return null;
            }
            return new int[]{num, gen};
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static enum TokenType {
        Number,
        String,
        Name,
        Comment,
        StartArray,
        EndArray,
        StartDic,
        EndDic,
        Ref,
        Obj,
        EndObj,
        Other,
        EndOfFile;

    }
}

