/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.core;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageKey;
import com.microsoft.azure.storage.core.BaseRequest;
import java.net.HttpURLConnection;
import java.security.InvalidKeyException;

public final class StorageCredentialsHelper {
    public static boolean canCredentialsSignRequest(StorageCredentials creds) {
        return creds.getClass().equals(StorageCredentialsAccountAndKey.class);
    }

    public static String computeHmac256(StorageCredentials creds, String value) throws InvalidKeyException {
        if (creds.getClass().equals(StorageCredentialsAccountAndKey.class)) {
            return StorageKey.computeMacSha256(((StorageCredentialsAccountAndKey)creds).getCredentials().getKey(), value);
        }
        return null;
    }

    public static void signBlobAndQueueRequest(StorageCredentials creds, HttpURLConnection request, long contentLength) throws InvalidKeyException, StorageException {
        StorageCredentialsHelper.signBlobQueueAndFileRequest(creds, request, contentLength, null);
    }

    public static void signBlobQueueAndFileRequest(StorageCredentials creds, HttpURLConnection request, long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        if (creds.getClass().equals(StorageCredentialsAccountAndKey.class)) {
            opContext = opContext == null ? new OperationContext() : opContext;
            BaseRequest.signRequestForBlobAndQueue(request, (StorageCredentialsAccountAndKey)creds, contentLength, opContext);
        }
    }

    public static void signTableRequest(StorageCredentials creds, HttpURLConnection request, long contentLength) throws InvalidKeyException, StorageException {
        StorageCredentialsHelper.signTableRequest(creds, request, contentLength, null);
    }

    public static void signTableRequest(StorageCredentials creds, HttpURLConnection request, long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        if (creds.getClass().equals(StorageCredentialsAccountAndKey.class)) {
            opContext = opContext == null ? new OperationContext() : opContext;
            BaseRequest.signRequestForTableSharedKey(request, (StorageCredentialsAccountAndKey)creds, contentLength, opContext);
        }
    }

    private StorageCredentialsHelper() {
    }
}

