/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.ByteOrderHack;
import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLPlatform;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.ReusablePointers;
import com.nativelibs4java.util.EnumValues;
import com.nativelibs4java.util.ValuedEnum;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bridj.Pointer;
import org.bridj.SizeT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLDevice
extends CLAbstractEntity {
    protected static CLInfoGetter infos = new CLInfoGetter(){

        @Override
        protected int getInfo(long entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
            return JavaCL.CL.clGetDeviceInfo(entity, infoTypeEnum, size, Pointer.getPeer((Pointer)out), Pointer.getPeer(sizeOut));
        }
    };
    volatile CLPlatform platform;
    private volatile ByteOrder byteOrder;
    private volatile ByteOrder kernelsDefaultByteOrder;
    private String[] extensions;

    CLDevice(CLPlatform platform, long device) {
        super(device);
        this.platform = platform;
    }

    public synchronized CLPlatform getPlatform() {
        if (this.platform == null) {
            Pointer pplat = infos.getPointer(this.getEntity(), 4145);
            this.platform = new CLPlatform(Pointer.getPeer((Pointer)pplat));
        }
        return this.platform;
    }

    @Override
    protected void clear() {
        CLException.error(JavaCL.CL.clReleaseDevice(this.getEntity()));
    }

    public String createSignature() {
        return this.getName() + "|" + this.getVendor() + "|" + this.getDriverVersion() + "|" + this.getProfile();
    }

    public static Map<String, List<CLDevice>> getDevicesBySignature(List<CLDevice> devices) {
        HashMap<String, List<CLDevice>> ret = new HashMap<String, List<CLDevice>>();
        for (CLDevice device : devices) {
            String signature = device.createSignature();
            ArrayList<CLDevice> list = (ArrayList<CLDevice>)ret.get(signature);
            if (list == null) {
                list = new ArrayList<CLDevice>();
                ret.put(signature, list);
            }
            list.add(device);
        }
        return ret;
    }

    public ByteOrder getByteOrder() {
        if (this.byteOrder == null) {
            this.byteOrder = this.isEndianLittle() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        }
        return this.byteOrder;
    }

    @Deprecated
    public synchronized ByteOrder getKernelsDefaultByteOrder() {
        if (this.kernelsDefaultByteOrder == null) {
            this.kernelsDefaultByteOrder = ByteOrderHack.guessByteOrderNeededForBuffers(this);
        }
        return this.kernelsDefaultByteOrder;
    }

    @InfoName(value="CL_DEVICE_EXECUTION_CAPABILITIES")
    public EnumSet<ExecutionCapability> getExecutionCapabilities() {
        return ExecutionCapability.getEnumSet(infos.getIntOrLong(this.getEntity(), 4137));
    }

    @InfoName(value="CL_DEVICE_TYPE")
    public EnumSet<Type> getType() {
        return Type.getEnumSet(infos.getIntOrLong(this.getEntity(), 4096));
    }

    @InfoName(value="CL_DEVICE_VENDOR_ID")
    public int getVendorId() {
        return infos.getInt(this.getEntity(), 4097);
    }

    @InfoName(value="CL_DEVICE_MAX_COMPUTE_UNITS")
    public int getMaxComputeUnits() {
        return infos.getInt(this.getEntity(), 4098);
    }

    @InfoName(value="CL_DEVICE_MAX_WORK_ITEM_DIMENSIONS")
    public int getMaxWorkItemDimensions() {
        return infos.getInt(this.getEntity(), 4099);
    }

    @InfoName(value="CL_DEVICE_MAX_WORK_ITEM_SIZES")
    public long[] getMaxWorkItemSizes() {
        long[] sizes = infos.getNativeSizes(this.getEntity(), 4101, this.getMaxWorkItemDimensions());
        int n = sizes.length;
        for (int i = 0; i < n; ++i) {
            long size = sizes[i];
            if ((size & 0xFFFFFFFF00000000L) != -3689348818177884160L) continue;
            sizes[i] = size & 0xFFFFFFFFL;
        }
        return sizes;
    }

    @InfoName(value="CL_DEVICE_MAX_WORK_GROUP_SIZE")
    public long getMaxWorkGroupSize() {
        return infos.getIntOrLong(this.getEntity(), 4100);
    }

    @InfoName(value="CL_DEVICE_MAX_CLOCK_FREQUENCY")
    public int getMaxClockFrequency() {
        return infos.getInt(this.getEntity(), 4108);
    }

    @InfoName(value="CL_DEVICE_ADDRESS_BITS")
    public int getAddressBits() {
        return infos.getInt(this.getEntity(), 4109);
    }

    @InfoName(value="CL_DEVICE_MAX_MEM_ALLOC_SIZE")
    public long getMaxMemAllocSize() {
        return infos.getIntOrLong(this.getEntity(), 4112);
    }

    @InfoName(value="CL_DEVICE_IMAGE_SUPPORT")
    public boolean hasImageSupport() {
        return infos.getBool(this.getEntity(), 4118);
    }

    @InfoName(value="CL_DEVICE_MAX_READ_IMAGE_ARGS")
    public int getMaxReadImageArgs() {
        return infos.getInt(this.getEntity(), 4110);
    }

    @InfoName(value="CL_DEVICE_MAX_WRITE_IMAGE_ARGS")
    public int getMaxWriteImageArgs() {
        return infos.getInt(this.getEntity(), 4111);
    }

    public String toString() {
        return this.getName() + " (" + this.getPlatform().getName() + ")";
    }

    public CLQueue createQueue(CLContext context, QueueProperties ... queueProperties) {
        ReusablePointers ptrs = ReusablePointers.get();
        Pointer<Integer> pErr = ptrs.pErr;
        long flags = 0L;
        for (QueueProperties prop : queueProperties) {
            flags |= prop.value();
        }
        long queue = JavaCL.CL.clCreateCommandQueue(context.getEntity(), this.getEntity(), flags, Pointer.getPeer(pErr));
        CLException.error(pErr.getInt());
        return new CLQueue(context, queue, this);
    }

    @Deprecated
    public CLQueue createQueue(EnumSet<QueueProperties> queueProperties, CLContext context) {
        ReusablePointers ptrs = ReusablePointers.get();
        Pointer<Integer> pErr = ptrs.pErr;
        long queue = JavaCL.CL.clCreateCommandQueue(context.getEntity(), this.getEntity(), QueueProperties.getValue(queueProperties), Pointer.getPeer(pErr));
        CLException.error(pErr.getInt());
        return new CLQueue(context, queue, this);
    }

    public CLQueue createOutOfOrderQueue(CLContext context) {
        return this.createQueue(EnumSet.of(QueueProperties.OutOfOrderExecModeEnable), context);
    }

    public CLQueue createProfilingQueue(CLContext context) {
        return this.createQueue(EnumSet.of(QueueProperties.ProfilingEnable), context);
    }

    @InfoName(value="CL_DEVICE_IMAGE2D_MAX_WIDTH")
    public long getImage2DMaxWidth() {
        return infos.getIntOrLong(this.getEntity(), 4113);
    }

    @InfoName(value="CL_DEVICE_IMAGE2D_MAX_HEIGHT")
    public long getImage2DMaxHeight() {
        return infos.getIntOrLong(this.getEntity(), 4114);
    }

    @InfoName(value="CL_DEVICE_IMAGE3D_MAX_WIDTH")
    public long getImage3DMaxWidth() {
        return infos.getIntOrLong(this.getEntity(), 4115);
    }

    @InfoName(value="CL_DEVICE_IMAGE3D_MAX_HEIGHT")
    public long getImage3DMaxHeight() {
        return infos.getIntOrLong(this.getEntity(), 4116);
    }

    @InfoName(value="CL_DEVICE_IMAGE3D_MAX_DEPTH")
    public long getImage3DMaxDepth() {
        return infos.getIntOrLong(this.getEntity(), 4117);
    }

    @InfoName(value="CL_DEVICE_MAX_SAMPLERS")
    public int getMaxSamplers() {
        return infos.getInt(this.getEntity(), 4120);
    }

    @InfoName(value="CL_DEVICE_MAX_PARAMETER_SIZE")
    public long getMaxParameterSize() {
        return infos.getIntOrLong(this.getEntity(), 4119);
    }

    @InfoName(value="CL_DEVICE_MEM_BASE_ADDR_ALIGN")
    public int getMemBaseAddrAlign() {
        return infos.getInt(this.getEntity(), 4121);
    }

    @InfoName(value="CL_DEVICE_MIN_DATA_TYPE_ALIGN_SIZE")
    public int getMinDataTypeAlign() {
        return infos.getInt(this.getEntity(), 4122);
    }

    @InfoName(value="CL_DEVICE_SINGLE_FP_CONFIG")
    public EnumSet<SingleFPConfig> getSingleFPConfig() {
        return SingleFPConfig.getEnumSet(infos.getIntOrLong(this.getEntity(), 4123));
    }

    @InfoName(value="CL_DEVICE_GLOBAL_MEM_CACHE_TYPE")
    public GlobalMemCacheType getGlobalMemCacheType() {
        return GlobalMemCacheType.getEnum(infos.getInt(this.getEntity(), 4124));
    }

    @InfoName(value="CL_DEVICE_GLOBAL_MEM_CACHELINE_SIZE")
    public int getGlobalMemCachelineSize() {
        return infos.getInt(this.getEntity(), 4125);
    }

    @InfoName(value="CL_DEVICE_GLOBAL_MEM_CACHE_SIZE")
    public long getGlobalMemCacheSize() {
        return infos.getIntOrLong(this.getEntity(), 4126);
    }

    @InfoName(value="CL_DEVICE_GLOBAL_MEM_SIZE")
    public long getGlobalMemSize() {
        return infos.getIntOrLong(this.getEntity(), 4127);
    }

    @InfoName(value="CL_DEVICE_MAX_CONSTANT_BUFFER_SIZE")
    public long getMaxConstantBufferSize() {
        return infos.getIntOrLong(this.getEntity(), 4128);
    }

    @InfoName(value="CL_DEVICE_MAX_CONSTANT_ARGS")
    public int getMaxConstantArgs() {
        return infos.getInt(this.getEntity(), 4129);
    }

    @InfoName(value="CL_DEVICE_LOCAL_MEM_TYPE")
    public LocalMemType getLocalMemType() {
        return LocalMemType.getEnum(infos.getInt(this.getEntity(), 4130));
    }

    @InfoName(value="CL_DEVICE_LOCAL_MEM_SIZE")
    public long getLocalMemSize() {
        return infos.getIntOrLong(this.getEntity(), 4131);
    }

    @InfoName(value="CL_DEVICE_ERROR_CORRECTION_SUPPORT")
    public boolean hasErrorCorrectionSupport() {
        return infos.getBool(this.getEntity(), 4132);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InfoName(value="Out of order queues support")
    public boolean hasOutOfOrderQueueSupport() {
        CLContext context = this.getPlatform().createContext(null, this);
        CLQueue queue = null;
        try {
            queue = this.createOutOfOrderQueue(context);
            boolean bl = true;
            return bl;
        }
        catch (CLException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (queue != null) {
                queue.release();
            }
            context.release();
        }
    }

    @InfoName(value="CL_DEVICE_PROFILING_TIMER_RESOLUTION")
    public long getProfilingTimerResolution() {
        return infos.getIntOrLong(this.getEntity(), 4133);
    }

    @InfoName(value="CL_DEVICE_ENDIAN_LITTLE")
    public boolean isEndianLittle() {
        return infos.getBool(this.getEntity(), 4134);
    }

    @InfoName(value="CL_DEVICE_AVAILABLE")
    public boolean isAvailable() {
        return infos.getBool(this.getEntity(), 4135);
    }

    @InfoName(value="CL_DEVICE_COMPILER_AVAILABLE")
    public boolean isCompilerAvailable() {
        return infos.getBool(this.getEntity(), 4136);
    }

    @InfoName(value="CL_DEVICE_NAME")
    public String getName() {
        return infos.getString(this.getEntity(), 4139);
    }

    @InfoName(value="CL_DEVICE_OPENCL_C_VERSION")
    public String getOpenCLVersion() {
        try {
            return infos.getString(this.getEntity(), 4157);
        }
        catch (Throwable th) {
            return "OpenCL C 1.0";
        }
    }

    @InfoName(value="CL_DEVICE_VENDOR")
    public String getVendor() {
        return infos.getString(this.getEntity(), 4140);
    }

    @InfoName(value="CL_DRIVER_VERSION")
    public String getDriverVersion() {
        return infos.getString(this.getEntity(), 4141);
    }

    @InfoName(value="CL_DEVICE_PROFILE")
    public String getProfile() {
        return infos.getString(this.getEntity(), 4142);
    }

    @InfoName(value="CL_DEVICE_HOST_UNIFIED_MEMORY")
    public boolean isHostUnifiedMemory() {
        try {
            return infos.getBool(this.getEntity(), 4149);
        }
        catch (Throwable th) {
            return false;
        }
    }

    @InfoName(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_CHAR")
    public int getPreferredVectorWidthChar() {
        return infos.getInt(this.getEntity(), 4102);
    }

    @InfoName(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_SHORT")
    public int getPreferredVectorWidthShort() {
        return infos.getInt(this.getEntity(), 4103);
    }

    @InfoName(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_INT")
    public int getPreferredVectorWidthInt() {
        return infos.getInt(this.getEntity(), 4104);
    }

    @InfoName(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_LONG")
    public int getPreferredVectorWidthLong() {
        return infos.getInt(this.getEntity(), 4105);
    }

    @InfoName(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_FLOAT")
    public int getPreferredVectorWidthFloat() {
        return infos.getInt(this.getEntity(), 4106);
    }

    @InfoName(value="CL_DEVICE_PREFERRED_VECTOR_WIDTH_DOUBLE")
    public int getPreferredVectorWidthDouble() {
        return infos.getInt(this.getEntity(), 4107);
    }

    @InfoName(value="CL_DEVICE_NATIVE_VECTOR_WIDTH_CHAR")
    public int getNativeVectorWidthChar() {
        return infos.getOptionalFeatureInt(this.getEntity(), 4150);
    }

    @InfoName(value="CL_DEVICE_NATIVE_VECTOR_WIDTH_SHORT")
    public int getNativeVectorWidthShort() {
        return infos.getOptionalFeatureInt(this.getEntity(), 4151);
    }

    @InfoName(value="CL_DEVICE_NATIVE_VECTOR_WIDTH_INT")
    public int getNativeVectorWidthInt() {
        return infos.getOptionalFeatureInt(this.getEntity(), 4152);
    }

    @InfoName(value="CL_DEVICE_NATIVE_VECTOR_WIDTH_LONG")
    public int getNativeVectorWidthLong() {
        return infos.getOptionalFeatureInt(this.getEntity(), 4153);
    }

    @InfoName(value="CL_DEVICE_NATIVE_VECTOR_WIDTH_FLOAT")
    public int getNativeVectorWidthFloat() {
        return infos.getOptionalFeatureInt(this.getEntity(), 4154);
    }

    @InfoName(value="CL_DEVICE_NATIVE_VECTOR_WIDTH_DOUBLE")
    public int getNativeVectorWidthDouble() {
        return infos.getOptionalFeatureInt(this.getEntity(), 4155);
    }

    @InfoName(value="CL_DEVICE_VERSION")
    public String getVersion() {
        return infos.getString(this.getEntity(), 4143);
    }

    @InfoName(value="CL_DEVICE_EXTENSIONS")
    public String[] getExtensions() {
        if (this.extensions == null) {
            this.extensions = infos.getString(this.getEntity(), 4144).split("\\s+");
        }
        return this.extensions;
    }

    public boolean hasExtension(String name) {
        name = name.trim();
        for (String x : this.getExtensions()) {
            if (!name.equals(x.trim())) continue;
            return true;
        }
        return false;
    }

    public boolean isDoubleSupported() {
        return this.isDoubleSupportedKHR() || this.isDoubleSupportedAMD();
    }

    public boolean isDoubleSupportedKHR() {
        return this.hasExtension("cl_khr_fp64");
    }

    public boolean isDoubleSupportedAMD() {
        return this.hasExtension("cl_amd_fp64");
    }

    public String replaceDoubleExtensionByExtensionActuallyAvailable(String kernelSource) {
        boolean hasKHR = this.isDoubleSupportedKHR();
        boolean hasAMD = this.isDoubleSupportedAMD();
        if (hasAMD && !hasKHR) {
            kernelSource = kernelSource.replaceAll("#pragma\\s+OPENCL\\s+EXTENSION\\s+cl_khr_fp64\\s*:\\s*enable", "#pragma OPENCL EXTENSION cl_amd_fp64 : enable");
        } else if (!hasAMD && hasKHR) {
            kernelSource = kernelSource.replaceAll("#pragma\\s+OPENCL\\s+EXTENSION\\s+cl_amd_fp64\\s*:\\s*enable", "#pragma OPENCL EXTENSION cl_khr_fp64 : enable");
        }
        return kernelSource;
    }

    public boolean isHalfSupported() {
        return this.hasExtension("cl_khr_fp16");
    }

    public boolean isByteAddressableStoreSupported() {
        return this.hasExtension("cl_khr_byte_addressable_store");
    }

    public boolean isGLSharingSupported() {
        return this.hasExtension("cl_khr_gl_sharing") || this.hasExtension("cl_APPLE_gl_sharing");
    }

    public boolean isGlobalInt32BaseAtomicsSupported() {
        return this.hasExtension("cl_khr_global_int32_base_atomics");
    }

    public boolean isGlobalInt32ExtendedAtomicsSupported() {
        return this.hasExtension("cl_khr_global_int32_extended_atomics");
    }

    public boolean isLocalInt32BaseAtomicsSupported() {
        return this.hasExtension("cl_khr_local_int32_base_atomics");
    }

    public boolean isLocalInt32ExtendedAtomicsSupported() {
        return this.hasExtension("cl_khr_local_int32_extended_atomics");
    }

    @InfoName(value="CL_DEVICE_QUEUE_PROPERTIES")
    public EnumSet<QueueProperties> getQueueProperties() {
        return QueueProperties.getEnumSet(infos.getIntOrLong(this.getEntity(), 4138));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueueProperties implements ValuedEnum
    {
        OutOfOrderExecModeEnable(1L),
        ProfilingEnable(2L);

        long value;

        private QueueProperties(long value) {
            this.value = value;
        }

        public long value() {
            return this.value;
        }

        public static long getValue(EnumSet<QueueProperties> set) {
            return EnumValues.getValue(set);
        }

        public static EnumSet<QueueProperties> getEnumSet(long v) {
            return EnumValues.getEnumSet((long)v, QueueProperties.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LocalMemType implements ValuedEnum
    {
        Local(1L),
        Global(2L);

        long value;

        private LocalMemType(long value) {
            this.value = value;
        }

        public long value() {
            return this.value;
        }

        public static LocalMemType getEnum(long v) {
            return (LocalMemType)EnumValues.getEnum((long)v, LocalMemType.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GlobalMemCacheType implements ValuedEnum
    {
        None(0L),
        ReadOnlyCache(1L),
        ReadWriteCache(2L);

        long value;

        private GlobalMemCacheType(long value) {
            this.value = value;
        }

        public long value() {
            return this.value;
        }

        public static GlobalMemCacheType getEnum(long v) {
            return (GlobalMemCacheType)EnumValues.getEnum((long)v, GlobalMemCacheType.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SingleFPConfig implements ValuedEnum
    {
        Denorm(1L),
        InfNaN(2L),
        RoundToNearest(4L),
        RoundToZero(8L),
        RoundToInf(16L),
        FMA(32L);

        long value;

        private SingleFPConfig(long value) {
            this.value = value;
        }

        public long value() {
            return this.value;
        }

        public static long getValue(EnumSet<SingleFPConfig> set) {
            return EnumValues.getValue(set);
        }

        public static EnumSet<SingleFPConfig> getEnumSet(long v) {
            return EnumValues.getEnumSet((long)v, SingleFPConfig.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type implements ValuedEnum
    {
        CPU(2L),
        GPU(4L),
        Accelerator(8L),
        Default(1L),
        All(-1L);

        long value;

        private Type(long value) {
            this.value = value;
        }

        public long value() {
            return this.value;
        }

        public static long getValue(EnumSet<Type> set) {
            return EnumValues.getValue(set);
        }

        public static EnumSet<Type> getEnumSet(long v) {
            return EnumValues.getEnumSet((long)v, Type.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExecutionCapability implements ValuedEnum
    {
        Kernel(1L),
        NativeKernel(2L);

        long value;

        private ExecutionCapability(long value) {
            this.value = value;
        }

        public long value() {
            return this.value;
        }

        public static long getValue(EnumSet<ExecutionCapability> set) {
            return EnumValues.getValue(set);
        }

        public static EnumSet<ExecutionCapability> getEnumSet(long v) {
            return EnumValues.getEnumSet((long)v, ExecutionCapability.class);
        }
    }
}

