/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.Address;
import com.amazonaws.services.ec2.model.AssociateAddressRequest;
import com.amazonaws.services.ec2.model.DescribeAddressesRequest;
import com.amazonaws.services.ec2.model.DescribeAddressesResult;
import com.amazonaws.services.ec2.model.DisassociateAddressRequest;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.endpoint.EndpointUtils;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.aws.AwsBinder;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.servo.monitor.Monitors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EIPManager
implements AwsBinder {
    private static final Logger logger = LoggerFactory.getLogger(EIPManager.class);
    private static final String US_EAST_1 = "us-east-1";
    private static final int EIP_BIND_SLEEP_TIME_MS = 1000;
    private static final Timer timer = new Timer("Eureka-EIPBinder", true);
    private final EurekaServerConfig serverConfig;
    private final EurekaClientConfig clientConfig;
    private final PeerAwareInstanceRegistry registry;
    private final ApplicationInfoManager applicationInfoManager;

    @Inject
    public EIPManager(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, PeerAwareInstanceRegistry registry, ApplicationInfoManager applicationInfoManager) {
        this.serverConfig = serverConfig;
        this.clientConfig = clientConfig;
        this.registry = registry;
        this.applicationInfoManager = applicationInfoManager;
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register the JMX monitor for the InstanceRegistry", e);
        }
    }

    @Override
    @PostConstruct
    public void start() {
        try {
            this.handleEIPBinding();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @PreDestroy
    public void shutdown() {
        timer.cancel();
        for (int i = 0; i < this.serverConfig.getEIPBindRebindRetries(); ++i) {
            try {
                this.unbindEIP();
                break;
            }
            catch (Exception e) {
                logger.warn("Cannot unbind the EIP from the instance");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    private void handleEIPBinding() throws InterruptedException {
        int retries = this.serverConfig.getEIPBindRebindRetries();
        for (int i = 0; i < retries; ++i) {
            try {
                if (this.isEIPBound()) break;
                this.bindEIP();
                continue;
            }
            catch (Throwable e) {
                logger.error("Cannot bind to EIP", e);
                Thread.sleep(1000L);
            }
        }
        timer.schedule((TimerTask)new EIPBindingTask(), this.serverConfig.getEIPBindingRetryIntervalMsWhenUnbound());
    }

    public boolean isEIPBound() {
        InstanceInfo myInfo = this.applicationInfoManager.getInfo();
        String myInstanceId = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.instanceId);
        String myZone = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.availabilityZone);
        String myPublicIP = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.publicIpv4);
        Collection<String> candidateEIPs = this.getCandidateEIPs(myInstanceId, myZone);
        for (String eipEntry : candidateEIPs) {
            if (!eipEntry.equals(myPublicIP)) continue;
            logger.info("My instance {} seems to be already associated with the public ip {}", (Object)myInstanceId, (Object)myPublicIP);
            return true;
        }
        return false;
    }

    public void bindEIP() {
        InstanceInfo myInfo = this.applicationInfoManager.getInfo();
        String myInstanceId = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.instanceId);
        String myZone = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.availabilityZone);
        Collection<String> candidateEIPs = this.getCandidateEIPs(myInstanceId, myZone);
        AmazonEC2 ec2Service = this.getEC2Service();
        boolean isMyinstanceAssociatedWithEIP = false;
        Address selectedEIP = null;
        for (String eipEntry : candidateEIPs) {
            try {
                DescribeAddressesRequest describeAddressRequest = new DescribeAddressesRequest().withPublicIps(new String[]{eipEntry});
                DescribeAddressesResult result = ec2Service.describeAddresses(describeAddressRequest);
                if (result.getAddresses() == null || result.getAddresses().isEmpty()) continue;
                Address eipAddress = (Address)result.getAddresses().get(0);
                String associatedInstanceId = eipAddress.getInstanceId();
                if (associatedInstanceId == null || associatedInstanceId.isEmpty()) {
                    if (selectedEIP != null) continue;
                    selectedEIP = eipAddress;
                    continue;
                }
                isMyinstanceAssociatedWithEIP = associatedInstanceId.equals(myInstanceId);
                if (isMyinstanceAssociatedWithEIP) {
                    selectedEIP = eipAddress;
                    break;
                }
                logger.warn("The selected EIP {} is associated with another instance {} according to AWS, hence skipping this", (Object)eipEntry, (Object)associatedInstanceId);
            }
            catch (Throwable t) {
                logger.error("Failed to bind elastic IP: {} to {}", new Object[]{eipEntry, myInstanceId, t});
            }
        }
        if (null != selectedEIP) {
            String publicIp = selectedEIP.getPublicIp();
            if (!isMyinstanceAssociatedWithEIP) {
                AssociateAddressRequest associateAddressRequest = new AssociateAddressRequest().withInstanceId(myInstanceId);
                String domain = selectedEIP.getDomain();
                if ("vpc".equals(domain)) {
                    associateAddressRequest.setAllocationId(selectedEIP.getAllocationId());
                } else {
                    associateAddressRequest.setPublicIp(publicIp);
                }
                ec2Service.associateAddress(associateAddressRequest);
                logger.info("\n\n\nAssociated {} running in zone: {} to elastic IP: {}", new Object[]{myInstanceId, myZone, publicIp});
            }
            logger.info("My instance {} seems to be already associated with the EIP {}", (Object)myInstanceId, (Object)publicIp);
        } else {
            logger.info("No EIP is free to be associated with this instance. Candidate EIPs are: {}", candidateEIPs);
        }
    }

    public void unbindEIP() throws Exception {
        InstanceInfo myInfo = this.applicationInfoManager.getInfo();
        String myPublicIP = null;
        if (myInfo != null && myInfo.getDataCenterInfo().getName() == DataCenterInfo.Name.Amazon) {
            myPublicIP = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.publicIpv4);
            if (myPublicIP == null) {
                logger.info("Instance is not associated with an EIP. Will not try to unbind");
                return;
            }
            try {
                AmazonEC2 ec2Service = this.getEC2Service();
                DescribeAddressesRequest describeAddressRequest = new DescribeAddressesRequest().withPublicIps(new String[]{myPublicIP});
                DescribeAddressesResult result = ec2Service.describeAddresses(describeAddressRequest);
                if (result.getAddresses() != null && !result.getAddresses().isEmpty()) {
                    Address eipAddress = (Address)result.getAddresses().get(0);
                    DisassociateAddressRequest dissociateRequest = new DisassociateAddressRequest();
                    String domain = eipAddress.getDomain();
                    if ("vpc".equals(domain)) {
                        dissociateRequest.setAssociationId(eipAddress.getAssociationId());
                    } else {
                        dissociateRequest.setPublicIp(eipAddress.getPublicIp());
                    }
                    ec2Service.disassociateAddress(dissociateRequest);
                    logger.info("Dissociated the EIP {} from this instance", (Object)myPublicIP);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Cannot dissociate address from this instance", e);
            }
        }
    }

    public Collection<String> getCandidateEIPs(String myInstanceId, String myZone) {
        Collection<String> eipCandidates;
        if (myZone == null) {
            myZone = "us-east-1d";
        }
        Collection<String> collection = eipCandidates = this.clientConfig.shouldUseDnsForFetchingServiceUrls() ? this.getEIPsForZoneFromDNS(myZone) : this.getEIPsForZoneFromConfig(myZone);
        if (eipCandidates == null || eipCandidates.size() == 0) {
            throw new RuntimeException("Could not get any elastic ips from the EIP pool for zone :" + myZone);
        }
        return eipCandidates;
    }

    private Collection<String> getEIPsForZoneFromConfig(String myZone) {
        List ec2Urls = this.clientConfig.getEurekaServerServiceUrls(myZone);
        return this.getEIPsFromServiceUrls(ec2Urls);
    }

    private Collection<String> getEIPsFromServiceUrls(List<String> ec2Urls) {
        ArrayList<String> returnedUrls = new ArrayList<String>();
        String region = this.clientConfig.getRegion();
        String regionPhrase = "";
        if (!US_EAST_1.equals(region)) {
            regionPhrase = "." + region;
        }
        for (String cname : ec2Urls) {
            int beginIndex = cname.indexOf("ec2-") + 4;
            if (-1 >= beginIndex) continue;
            int endIndex = cname.indexOf(regionPhrase + ".compute");
            String eipStr = cname.substring(beginIndex, endIndex);
            String eip = eipStr.replaceAll("\\-", ".");
            returnedUrls.add(eip);
        }
        return returnedUrls;
    }

    private Collection<String> getEIPsForZoneFromDNS(String myZone) {
        List ec2Urls = EndpointUtils.getServiceUrlsFromDNS((EurekaClientConfig)this.clientConfig, (String)myZone, (boolean)true, (EndpointUtils.ServiceUrlRandomizer)new EndpointUtils.InstanceInfoBasedUrlRandomizer(this.applicationInfoManager.getInfo()));
        return this.getEIPsFromServiceUrls(ec2Urls);
    }

    private AmazonEC2 getEC2Service() {
        String aWSAccessId = this.serverConfig.getAWSAccessId();
        String aWSSecretKey = this.serverConfig.getAWSSecretKey();
        AmazonEC2Client ec2Service = null != aWSAccessId && !"".equals(aWSAccessId) && null != aWSSecretKey && !"".equals(aWSSecretKey) ? new AmazonEC2Client((AWSCredentials)new BasicAWSCredentials(aWSAccessId, aWSSecretKey)) : new AmazonEC2Client((AWSCredentialsProvider)new InstanceProfileCredentialsProvider());
        String region = this.clientConfig.getRegion();
        region = region.trim().toLowerCase();
        ec2Service.setEndpoint("ec2." + region + ".amazonaws.com");
        return ec2Service;
    }

    private class EIPBindingTask
    extends TimerTask {
        private EIPBindingTask() {
        }

        @Override
        public void run() {
            boolean isEIPBound = false;
            try {
                isEIPBound = EIPManager.this.isEIPBound();
                if (isEIPBound) {
                    return;
                }
                EIPManager.this.registry.clearRegistry();
                int count = EIPManager.this.registry.syncUp();
                EIPManager.this.registry.openForTraffic(EIPManager.this.applicationInfoManager, count);
                EIPManager.this.bindEIP();
            }
            catch (Throwable e) {
                logger.error("Could not bind to EIP", e);
            }
            finally {
                if (isEIPBound) {
                    timer.schedule((TimerTask)new EIPBindingTask(), EIPManager.this.serverConfig.getEIPBindingRetryIntervalMs());
                } else {
                    timer.schedule((TimerTask)new EIPBindingTask(), EIPManager.this.serverConfig.getEIPBindingRetryIntervalMsWhenUnbound());
                }
            }
        }
    }
}

