/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mockwebserver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.WebSocketListener;
import okhttp3.internal.Internal;
import okhttp3.internal.http2.Settings;
import okhttp3.mockwebserver.PushPromise;
import okhttp3.mockwebserver.SocketPolicy;
import okhttp3.mockwebserver.internal.duplex.DuplexResponseBody;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b'\u0018\u0000 j2\u00020\u0001:\u0001jB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u000200J\u0016\u0010A\u001a\u00020\u00002\u0006\u0010C\u001a\u0002002\u0006\u0010\u000e\u001a\u00020DJ\u0016\u0010E\u001a\u00020\u00002\u0006\u0010C\u001a\u0002002\u0006\u0010\u000e\u001a\u00020DJ\u0006\u0010F\u001a\u00020\u0000J\b\u0010G\u001a\u00020\u0000H\u0016J\b\u0010H\u001a\u0004\u0018\u00010\u0004J\u000e\u0010I\u001a\u00020\u00062\u0006\u0010J\u001a\u00020\bJ\r\u0010\u0011\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\bKJ\u000e\u0010L\u001a\u00020\u00062\u0006\u0010J\u001a\u00020\bJ\r\u0010\u001a\u001a\u00020\u0018H\u0007\u00a2\u0006\u0002\bMJ\r\u0010-\u001a\u00020+H\u0007\u00a2\u0006\u0002\bNJ\r\u00102\u001a\u000200H\u0007\u00a2\u0006\u0002\bOJ\u000e\u0010P\u001a\u00020\u00062\u0006\u0010J\u001a\u00020\bJ\r\u0010;\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\bQJ\u000e\u0010R\u001a\u00020\u00002\u0006\u0010C\u001a\u000200J\u000e\u0010S\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u000200J\u000e\u0010S\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010S\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010T\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u00062\u0006\u0010J\u001a\u00020\bJ\u0016\u0010V\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u0002002\u0006\u0010W\u001a\u00020\u0018J\u0016\u0010V\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010W\u001a\u00020\u0018J\u0016\u0010X\u001a\u00020\u00002\u0006\u0010C\u001a\u0002002\u0006\u0010\u000e\u001a\u00020DJ\u000e\u0010Y\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000fJ\u0016\u0010Z\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u00062\u0006\u0010J\u001a\u00020\bJ\u000e\u0010[\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\\\u001a\u00020\u00002\u0006\u0010]\u001a\u00020\u0018J\u000e\u0010^\u001a\u00020\u00002\u0006\u0010,\u001a\u00020+J\u000e\u0010_\u001a\u00020\u00002\u0006\u00101\u001a\u000200J\u000e\u0010`\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u000fJ\u001e\u0010a\u001a\u00020\u00002\u0006\u0010b\u001a\u00020\u00062\u0006\u0010c\u001a\u00020\u00062\u0006\u0010J\u001a\u00020\bJ\b\u0010d\u001a\u000200H\u0016J\u000e\u0010e\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\"J\u000e\u0010g\u001a\u00020\u00002\u0006\u0010(\u001a\u00020'J\u000e\u0010h\u001a\u00020\u00002\u0006\u0010i\u001a\u00020=R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f8F@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0010\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u0018@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u0019\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001e\u0010(\u001a\u00020'2\u0006\u0010\t\u001a\u00020'@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R$\u0010,\u001a\u00020+2\u0006\u0010\t\u001a\u00020+@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b,\u0010/R$\u00101\u001a\u0002002\u0006\u0010\t\u001a\u000200@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b1\u00104R\u001e\u00105\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u000e\u00108\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010:\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f8F@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010\u0012\"\u0004\b:\u0010\u0013R\u000e\u0010<\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010>\u001a\u0004\u0018\u00010=2\b\u0010\t\u001a\u0004\u0018\u00010=@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@\u00a8\u0006k"}, d2={"Lokhttp3/mockwebserver/MockResponse;", "", "()V", "body", "Lokio/Buffer;", "bodyDelayAmount", "", "bodyDelayUnit", "Ljava/util/concurrent/TimeUnit;", "<set-?>", "Lokhttp3/mockwebserver/internal/duplex/DuplexResponseBody;", "duplexResponseBody", "getDuplexResponseBody", "()Lokhttp3/mockwebserver/internal/duplex/DuplexResponseBody;", "value", "Lokhttp3/Headers;", "headers", "getHeaders", "()Lokhttp3/Headers;", "(Lokhttp3/Headers;)V", "headersBuilder", "Lokhttp3/Headers$Builder;", "headersDelayAmount", "headersDelayUnit", "", "http2ErrorCode", "getHttp2ErrorCode", "()I", "(I)V", "isDuplex", "", "()Z", "promises", "", "Lokhttp3/mockwebserver/PushPromise;", "pushPromises", "", "getPushPromises", "()Ljava/util/List;", "Lokhttp3/internal/http2/Settings;", "settings", "getSettings", "()Lokhttp3/internal/http2/Settings;", "Lokhttp3/mockwebserver/SocketPolicy;", "socketPolicy", "getSocketPolicy", "()Lokhttp3/mockwebserver/SocketPolicy;", "(Lokhttp3/mockwebserver/SocketPolicy;)V", "", "status", "getStatus", "()Ljava/lang/String;", "(Ljava/lang/String;)V", "throttleBytesPerPeriod", "getThrottleBytesPerPeriod", "()J", "throttlePeriodAmount", "throttlePeriodUnit", "trailers", "getTrailers", "trailersBuilder", "Lokhttp3/WebSocketListener;", "webSocketListener", "getWebSocketListener", "()Lokhttp3/WebSocketListener;", "addHeader", "header", "name", "", "addHeaderLenient", "clearHeaders", "clone", "getBody", "getBodyDelay", "unit", "-deprecated_getHeaders", "getHeadersDelay", "-deprecated_getHttp2ErrorCode", "-deprecated_getSocketPolicy", "-deprecated_getStatus", "getThrottlePeriod", "-deprecated_getTrailers", "removeHeader", "setBody", "setBodyDelay", "delay", "setChunkedBody", "maxChunkSize", "setHeader", "setHeaders", "setHeadersDelay", "setHttp2ErrorCode", "setResponseCode", "code", "setSocketPolicy", "setStatus", "setTrailers", "throttleBody", "bytesPerPeriod", "period", "toString", "withPush", "promise", "withSettings", "withWebSocketUpgrade", "listener", "Companion", "mockwebserver"})
public final class MockResponse
implements Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String status = "";
    @NotNull
    private Headers.Builder headersBuilder = new Headers.Builder();
    @NotNull
    private Headers.Builder trailersBuilder = new Headers.Builder();
    @Nullable
    private Buffer body;
    private long throttleBytesPerPeriod = Long.MAX_VALUE;
    private long throttlePeriodAmount = 1L;
    @NotNull
    private TimeUnit throttlePeriodUnit = TimeUnit.SECONDS;
    @NotNull
    private SocketPolicy socketPolicy = SocketPolicy.KEEP_OPEN;
    private int http2ErrorCode = -1;
    private long bodyDelayAmount;
    @NotNull
    private TimeUnit bodyDelayUnit = TimeUnit.MILLISECONDS;
    private long headersDelayAmount;
    @NotNull
    private TimeUnit headersDelayUnit = TimeUnit.MILLISECONDS;
    @NotNull
    private List<PushPromise> promises = new ArrayList();
    @NotNull
    private Settings settings = new Settings();
    @Nullable
    private WebSocketListener webSocketListener;
    @Nullable
    private DuplexResponseBody duplexResponseBody;
    @NotNull
    private static final String CHUNKED_BODY_HEADER = "Transfer-encoding: chunked";

    public MockResponse() {
        this.setResponseCode(200);
        this.setHeader("Content-Length", 0L);
    }

    @NotNull
    public final String getStatus() {
        return this.status;
    }

    @JvmName(name="status")
    public final void status(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.status = string;
    }

    @NotNull
    public final Headers getHeaders() {
        return this.headersBuilder.build();
    }

    @JvmName(name="headers")
    public final void headers(@NotNull Headers value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.headersBuilder = value.newBuilder();
    }

    @NotNull
    public final Headers getTrailers() {
        return this.trailersBuilder.build();
    }

    @JvmName(name="trailers")
    public final void trailers(@NotNull Headers value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.trailersBuilder = value.newBuilder();
    }

    public final long getThrottleBytesPerPeriod() {
        return this.throttleBytesPerPeriod;
    }

    @NotNull
    public final SocketPolicy getSocketPolicy() {
        return this.socketPolicy;
    }

    @JvmName(name="socketPolicy")
    public final void socketPolicy(@NotNull SocketPolicy socketPolicy) {
        Intrinsics.checkNotNullParameter((Object)((Object)socketPolicy), (String)"<set-?>");
        this.socketPolicy = socketPolicy;
    }

    public final int getHttp2ErrorCode() {
        return this.http2ErrorCode;
    }

    @JvmName(name="http2ErrorCode")
    public final void http2ErrorCode(int n) {
        this.http2ErrorCode = n;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @Nullable
    public final WebSocketListener getWebSocketListener() {
        return this.webSocketListener;
    }

    @Nullable
    public final DuplexResponseBody getDuplexResponseBody() {
        return this.duplexResponseBody;
    }

    public final boolean isDuplex() {
        return this.duplexResponseBody != null;
    }

    @NotNull
    public final List<PushPromise> getPushPromises() {
        return this.promises;
    }

    @NotNull
    public MockResponse clone() {
        MockResponse result = (MockResponse)super.clone();
        result.headersBuilder = this.headersBuilder.build().newBuilder();
        result.promises = CollectionsKt.toMutableList((Collection)this.promises);
        return result;
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(expression="status", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_getStatus")
    @NotNull
    public final String -deprecated_getStatus() {
        return this.status;
    }

    @NotNull
    public final MockResponse setStatus(@NotNull String status) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        MockResponse $this$setStatus_u24lambda_u2d0 = mockResponse = this;
        boolean bl = false;
        $this$setStatus_u24lambda_u2d0.status(status);
        return mockResponse;
    }

    @NotNull
    public final MockResponse setResponseCode(int code) {
        MockResponse mockResponse;
        String string;
        block1: {
            int n;
            block3: {
                block2: {
                    block0: {
                        n = code;
                        boolean bl = 100 <= n ? n < 200 : false;
                        if (!bl) break block0;
                        string = "Informational";
                        break block1;
                    }
                    boolean bl = 200 <= n ? n < 300 : false;
                    if (!bl) break block2;
                    string = "OK";
                    break block1;
                }
                boolean bl = 300 <= n ? n < 400 : false;
                if (!bl) break block3;
                string = "Redirection";
                break block1;
            }
            string = (400 <= n ? n < 500 : false) ? "Client Error" : ((500 <= n ? n < 600 : false) ? "Server Error" : "Mock Response");
        }
        String reason = string;
        MockResponse $this$setResponseCode_u24lambda_u2d1 = mockResponse = this;
        boolean bl = false;
        $this$setResponseCode_u24lambda_u2d1.status("HTTP/1.1 " + code + ' ' + reason);
        return mockResponse;
    }

    @NotNull
    public final MockResponse clearHeaders() {
        MockResponse mockResponse;
        MockResponse $this$clearHeaders_u24lambda_u2d2 = mockResponse = this;
        boolean bl = false;
        $this$clearHeaders_u24lambda_u2d2.headersBuilder = new Headers.Builder();
        return mockResponse;
    }

    @NotNull
    public final MockResponse addHeader(@NotNull String header) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        MockResponse $this$addHeader_u24lambda_u2d3 = mockResponse = this;
        boolean bl = false;
        $this$addHeader_u24lambda_u2d3.headersBuilder.add(header);
        return mockResponse;
    }

    @NotNull
    public final MockResponse addHeader(@NotNull String name, @NotNull Object value) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        MockResponse $this$addHeader_u24lambda_u2d4 = mockResponse = this;
        boolean bl = false;
        $this$addHeader_u24lambda_u2d4.headersBuilder.add(name, value.toString());
        return mockResponse;
    }

    @NotNull
    public final MockResponse addHeaderLenient(@NotNull String name, @NotNull Object value) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        MockResponse $this$addHeaderLenient_u24lambda_u2d5 = mockResponse = this;
        boolean bl = false;
        Internal.addHeaderLenient((Headers.Builder)$this$addHeaderLenient_u24lambda_u2d5.headersBuilder, (String)name, (String)value.toString());
        return mockResponse;
    }

    @NotNull
    public final MockResponse setHeader(@NotNull String name, @NotNull Object value) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        MockResponse $this$setHeader_u24lambda_u2d6 = mockResponse = this;
        boolean bl = false;
        $this$setHeader_u24lambda_u2d6.removeHeader(name);
        $this$setHeader_u24lambda_u2d6.addHeader(name, value);
        return mockResponse;
    }

    @NotNull
    public final MockResponse removeHeader(@NotNull String name) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        MockResponse $this$removeHeader_u24lambda_u2d7 = mockResponse = this;
        boolean bl = false;
        $this$removeHeader_u24lambda_u2d7.headersBuilder.removeAll(name);
        return mockResponse;
    }

    @Nullable
    public final Buffer getBody() {
        Buffer buffer = this.body;
        return buffer == null ? null : buffer.clone();
    }

    @NotNull
    public final MockResponse setBody(@NotNull Buffer body) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        MockResponse $this$setBody_u24lambda_u2d8 = mockResponse = this;
        boolean bl = false;
        $this$setBody_u24lambda_u2d8.setHeader("Content-Length", body.size());
        $this$setBody_u24lambda_u2d8.body = body.clone();
        return mockResponse;
    }

    @NotNull
    public final MockResponse setBody(@NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return this.setBody(new Buffer().writeUtf8(body));
    }

    @NotNull
    public final MockResponse setBody(@NotNull DuplexResponseBody duplexResponseBody) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)duplexResponseBody, (String)"duplexResponseBody");
        MockResponse $this$setBody_u24lambda_u2d9 = mockResponse = this;
        boolean bl = false;
        $this$setBody_u24lambda_u2d9.duplexResponseBody = duplexResponseBody;
        return mockResponse;
    }

    @NotNull
    public final MockResponse setChunkedBody(@NotNull Buffer body, int maxChunkSize) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        MockResponse $this$setChunkedBody_u24lambda_u2d10 = mockResponse = this;
        boolean bl = false;
        $this$setChunkedBody_u24lambda_u2d10.removeHeader("Content-Length");
        $this$setChunkedBody_u24lambda_u2d10.headersBuilder.add(CHUNKED_BODY_HEADER);
        Buffer bytesOut = new Buffer();
        while (!body.exhausted()) {
            long chunkSize = Math.min(body.size(), (long)maxChunkSize);
            bytesOut.writeHexadecimalUnsignedLong(chunkSize);
            bytesOut.writeUtf8("\r\n");
            bytesOut.write(body, chunkSize);
            bytesOut.writeUtf8("\r\n");
        }
        bytesOut.writeUtf8("0\r\n");
        $this$setChunkedBody_u24lambda_u2d10.body = bytesOut;
        return mockResponse;
    }

    @NotNull
    public final MockResponse setChunkedBody(@NotNull String body, int maxChunkSize) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return this.setChunkedBody(new Buffer().writeUtf8(body), maxChunkSize);
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(expression="headers", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_getHeaders")
    @NotNull
    public final Headers -deprecated_getHeaders() {
        return this.getHeaders();
    }

    @NotNull
    public final MockResponse setHeaders(@NotNull Headers headers) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        MockResponse $this$setHeaders_u24lambda_u2d11 = mockResponse = this;
        boolean bl = false;
        $this$setHeaders_u24lambda_u2d11.headers(headers);
        return mockResponse;
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(expression="trailers", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_getTrailers")
    @NotNull
    public final Headers -deprecated_getTrailers() {
        return this.getTrailers();
    }

    @NotNull
    public final MockResponse setTrailers(@NotNull Headers trailers) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)trailers, (String)"trailers");
        MockResponse $this$setTrailers_u24lambda_u2d12 = mockResponse = this;
        boolean bl = false;
        $this$setTrailers_u24lambda_u2d12.trailers(trailers);
        return mockResponse;
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(expression="socketPolicy", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_getSocketPolicy")
    @NotNull
    public final SocketPolicy -deprecated_getSocketPolicy() {
        return this.socketPolicy;
    }

    @NotNull
    public final MockResponse setSocketPolicy(@NotNull SocketPolicy socketPolicy) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)((Object)socketPolicy), (String)"socketPolicy");
        MockResponse $this$setSocketPolicy_u24lambda_u2d13 = mockResponse = this;
        boolean bl = false;
        $this$setSocketPolicy_u24lambda_u2d13.socketPolicy(socketPolicy);
        return mockResponse;
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(expression="http2ErrorCode", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_getHttp2ErrorCode")
    public final int -deprecated_getHttp2ErrorCode() {
        return this.http2ErrorCode;
    }

    @NotNull
    public final MockResponse setHttp2ErrorCode(int http2ErrorCode) {
        MockResponse mockResponse;
        MockResponse $this$setHttp2ErrorCode_u24lambda_u2d14 = mockResponse = this;
        boolean bl = false;
        $this$setHttp2ErrorCode_u24lambda_u2d14.http2ErrorCode(http2ErrorCode);
        return mockResponse;
    }

    @NotNull
    public final MockResponse throttleBody(long bytesPerPeriod, long period, @NotNull TimeUnit unit) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        MockResponse $this$throttleBody_u24lambda_u2d15 = mockResponse = this;
        boolean bl = false;
        $this$throttleBody_u24lambda_u2d15.throttleBytesPerPeriod = bytesPerPeriod;
        $this$throttleBody_u24lambda_u2d15.throttlePeriodAmount = period;
        $this$throttleBody_u24lambda_u2d15.throttlePeriodUnit = unit;
        return mockResponse;
    }

    public final long getThrottlePeriod(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return unit.convert(this.throttlePeriodAmount, this.throttlePeriodUnit);
    }

    @NotNull
    public final MockResponse setBodyDelay(long delay, @NotNull TimeUnit unit) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        MockResponse $this$setBodyDelay_u24lambda_u2d16 = mockResponse = this;
        boolean bl = false;
        $this$setBodyDelay_u24lambda_u2d16.bodyDelayAmount = delay;
        $this$setBodyDelay_u24lambda_u2d16.bodyDelayUnit = unit;
        return mockResponse;
    }

    public final long getBodyDelay(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return unit.convert(this.bodyDelayAmount, this.bodyDelayUnit);
    }

    @NotNull
    public final MockResponse setHeadersDelay(long delay, @NotNull TimeUnit unit) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        MockResponse $this$setHeadersDelay_u24lambda_u2d17 = mockResponse = this;
        boolean bl = false;
        $this$setHeadersDelay_u24lambda_u2d17.headersDelayAmount = delay;
        $this$setHeadersDelay_u24lambda_u2d17.headersDelayUnit = unit;
        return mockResponse;
    }

    public final long getHeadersDelay(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return unit.convert(this.headersDelayAmount, this.headersDelayUnit);
    }

    @NotNull
    public final MockResponse withPush(@NotNull PushPromise promise) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        MockResponse $this$withPush_u24lambda_u2d18 = mockResponse = this;
        boolean bl = false;
        $this$withPush_u24lambda_u2d18.promises.add(promise);
        return mockResponse;
    }

    @NotNull
    public final MockResponse withSettings(@NotNull Settings settings) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        MockResponse $this$withSettings_u24lambda_u2d19 = mockResponse = this;
        boolean bl = false;
        $this$withSettings_u24lambda_u2d19.settings = settings;
        return mockResponse;
    }

    @NotNull
    public final MockResponse withWebSocketUpgrade(@NotNull WebSocketListener listener) {
        MockResponse mockResponse;
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        MockResponse $this$withWebSocketUpgrade_u24lambda_u2d20 = mockResponse = this;
        boolean bl = false;
        $this$withWebSocketUpgrade_u24lambda_u2d20.status("HTTP/1.1 101 Switching Protocols");
        $this$withWebSocketUpgrade_u24lambda_u2d20.setHeader("Connection", "Upgrade");
        $this$withWebSocketUpgrade_u24lambda_u2d20.setHeader("Upgrade", "websocket");
        $this$withWebSocketUpgrade_u24lambda_u2d20.body = null;
        $this$withWebSocketUpgrade_u24lambda_u2d20.webSocketListener = listener;
        return mockResponse;
    }

    @NotNull
    public String toString() {
        return this.status;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/mockwebserver/MockResponse$Companion;", "", "()V", "CHUNKED_BODY_HEADER", "", "mockwebserver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

